#include "ELYSE/SteppingAction.hh"

//GEANT 4
#include "G4SteppingManager.hh"
#include "G4SDManager.hh"
#include "G4EventManager.hh"
#include "G4ProcessManager.hh"
#include "G4Track.hh"
#include "G4Step.hh"
#include "G4Event.hh"
#include "G4StepPoint.hh"
#include "G4TrackStatus.hh"
#include "G4VPhysicalVolume.hh"
#include "G4ParticleDefinition.hh"
#include "G4ParticleTypes.hh"
#include "G4OpBoundaryProcess.hh"

//ELYSE
#include "ELYSE/EventAction.hh"
#include "ELYSE/TrackingAction.hh"
#include "ELYSE/Trajectory.hh"
//#include "ELYSE/TrappingVolume.hh"
#include "ELYSE/TrackInformation.hh"


ELYSE::SteppingAction::SteppingAction() {
}//Ctor

//---------------------------------------------------------------------------------------------------

ELYSE::SteppingAction::~SteppingAction() {
}//Dtor

//---------------------------------------------------------------------------------------------------
void ELYSE::SteppingAction::UserSteppingAction(const G4Step * theStep){

  G4Track* theTrack = theStep->GetTrack();

  G4StepPoint* thePostPoint = theStep->GetPostStepPoint();
  G4VPhysicalVolume* thePostPV = thePostPoint->GetPhysicalVolume();

  
  //JEC START debug Optical surface properties
//   G4StepPoint* pPreStepPoint  = theStep->GetPreStepPoint();
//   G4cout << "(JEC): UserSteppingAction PrePoint Volume:" <<  pPreStepPoint->GetPhysicalVolume()->GetName()
// 	 << " PostPoint Volume: " << thePostPV->GetName()
// 	 << G4endl;
//   G4LogicalSurface* Surface = 
//     G4LogicalSkinSurface::GetSurface(pPreStepPoint->GetPhysicalVolume()->GetLogicalVolume());
//   G4OpticalSurface* OpticalSurface = 0;
//   if (Surface) OpticalSurface = (G4OpticalSurface*) Surface->GetSurfaceProperty();
//   if (OpticalSurface) { 
//     G4cout << "(JEC) UserSteppingAction: Optical Surface Found" << G4endl;
//     OpticalSurface->DumpInfo();    
//     G4MaterialPropertiesTable* aMaterialPropertiesTable;
//     G4MaterialPropertyVector* Rindex;
//     aMaterialPropertiesTable = OpticalSurface->GetMaterialPropertiesTable();
    
//     if (aMaterialPropertiesTable) {
// 	Rindex = aMaterialPropertiesTable->GetProperty("RINDEX");
// 	if (Rindex) {
// 	  G4cout << "(JEC) Found RINDEX properties: " << G4endl;
// 	  Rindex->DumpVector();
// 	} else {
// 	  G4cout << "(JEC) NO  RINDEX properties " << G4endl;
// 	}
//     } else {
//       G4cout << "(JEC) NO  MATERIAL properties " << G4endl;
//     }
//   } else {
//     G4cout << "(JEC) NO OpticalSurface " << G4endl;
//   }
  
  G4OpBoundaryProcessStatus boundaryStatus=Undefined;
  static G4OpBoundaryProcess* boundary=NULL;
 
  if(!thePostPV){//out of world
    return;}

  G4ParticleDefinition* particleType = theTrack->GetDefinition();
  G4String              particleName = particleType->GetParticleName();

  //-----------only optical photons 

  if(particleName == "opticalphoton") {

    //------------find the boundary process only once
    if( !boundary ) {
      G4ProcessManager* pm = theStep->GetTrack()->GetDefinition()->GetProcessManager();
      G4int nprocesses = pm->GetProcessListLength();
      G4ProcessVector* pv = pm->GetProcessList();
      G4int i;
      for( i=0;i<nprocesses;i++){
	if((*pv)[i]->GetProcessName()=="OpBoundary"){
	  boundary = (G4OpBoundaryProcess*)(*pv)[i];  
	  break;
	}
      }
    }//set boundary once

    //if the OpticalBoundary process is not registered for Optical Photon => FATAL error
    if(!boundary) {
      G4cout << "(JEC) UserSteppingAction: FATAL: NO OpBoundary FOUND" << G4endl;
      exit(0);
    }
    
    //------------Kill photons entering expHall

//     G4cout << "(JEC) UserSteppingAction: Post Volume " << thePostPV->GetName()
// 	   << G4endl;

    if(thePostPV->GetName()=="expHall") {
      theTrack->SetTrackStatus(fStopAndKill);}

    //-----------  

    boundaryStatus = boundary->GetStatus();
 
    // Check to see if the particle was actually at a boundary
    // Otherwise the boundary status may not be valid
    // Prior to Geant4.6.0-p1 this would not have been enough to check

    if(thePostPoint->GetStepStatus()==fGeomBoundary) {

//possible  G4OpBoundaryProcessStatus {  Undefined,
//                                   FresnelRefraction, FresnelReflection,
//                                   TotalInternalReflection,
//                                   LambertianReflection, LobeReflection,
//                                   SpikeReflection, BackScattering,
//                                   Absorption, Detection, NotAtBoundary,
//                                   SameMaterial, StepTooSmall, NoRINDEX}
//       switch(boundaryStatus){
//       case FresnelRefraction:
//        	G4cout << "(JEC) Status of PostPoint: FresnelRefraction" << G4endl; break;
//       case FresnelReflection:
// 	G4cout << "(JEC) Status of PostPoint: FresnelReflection" << G4endl; break;
//       case TotalInternalReflection:
// 	G4cout << "(JEC) Status of PostPoint: TotalInternalReflection" << G4endl; break;
//        case LambertianReflection:
// 	G4cout << "(JEC) Status of PostPoint: LambertianReflection" << G4endl; break;
//       case LobeReflection:
// 	G4cout << "(JEC) Status of PostPoint: LobeReflection" << G4endl; break;
//       case SpikeReflection:
// 	G4cout << "(JEC) Status of PostPoint: SpikeReflection" << G4endl; break;
//       case Absorption:
// 	G4cout << "(JEC) Status of PostPoint: Absorption" << G4endl; break;
//       case Detection: 
// 	G4cout << "(JEC) Status of PostPoint: Detection" << G4endl; break;
//       case NotAtBoundary:
// 	G4cout << "(JEC) Status of PostPoint: NotAtBoundary" << G4endl; break;
//       case SameMaterial:
// 	G4cout << "(JEC) Status of PostPoint: SameMaterial" << G4endl; break;
//       case StepTooSmall:
// 	G4cout << "(JEC) Status of PostPoint: StepTooSmall" << G4endl; break;
//       case NoRINDEX:
// 	G4cout << "(JEC) Status of PostPoint: NoRINDEX" << G4endl; break;

//       default:
// 	break;

//       }//eo switch on boundary values

    }//test on GeomBoundary

  }//Optical photon


}//UserSteppingAction


















