#include "ELYSE/TrackInformation.hh"
#include "G4ios.hh"

namespace ELYSE {
  G4Allocator<TrackInformation> aTrackInfoAllocator;
}

ELYSE::TrackInformation::TrackInformation(const G4Track*) {
  saveit = false;
  drawit = false;
  status = active;
}//Ctor


//------------------------------------------------------------------------
void ELYSE::TrackInformation::AddTrackStatusFlag(int s) {
  if(s&active) { //track is now active
    status&=~inactive; //remove any flags indicating it is inactive 
  } else if(s&inactive) { //track is now inactive
    status&=~active;
  } else { //remove any flags indicating it is active
  status|=s; //add new flags
  }
}//AddTrackStatusFlag

//------------------------------------------------------------------------
void ELYSE::TrackInformation::Print() const {
  G4cout << "TrackInformation : [" << saveit 
	 << "]-[" << drawit 
	 << "]-[" << status << "]"
	 << G4endl;
}//Print


