#include "ELYSE/TrackingAction.hh"

//Geant4
#include "G4ParticleTable.hh"
#include "G4ParticleTypes.hh"
#include "G4TrackingManager.hh"
#include "G4Track.hh"
#include "G4ios.hh"
#include "G4VProcess.hh"

//ELYSE
#include "ELYSE/Trajectory.hh"
#include "ELYSE/TrackInformation.hh"  
#include "ELYSE/TrackingActionMessenger.hh"

ELYSE::TrackingAction::TrackingAction() {
  ProcessList.insert("eIoni") ;

  G4ParticleTable* particleTable = G4ParticleTable::GetParticleTable();
  ParticleList.insert(particleTable->FindParticle("e-")->GetPDGEncoding());
  ParticleList.insert(particleTable->FindParticle("e+")->GetPDGEncoding());
  

  // don't put gammas there or there'll be too many

  messenger = new TrackingActionMessenger(this);

}//Ctor

//--------------------------------------------------------------------------------------------------

ELYSE::TrackingAction::~TrackingAction(){
  //JEC 24/1/06
  delete messenger;
  messenger = 0;
}//Dtor

//---------------------------------------------------------------------------------------------------

void ELYSE::TrackingAction::PreUserTrackingAction(const G4Track* aTrack) {

  G4ParticleDefinition*      particleType      = aTrack->GetDefinition();
  G4String                   particleName      = particleType->GetParticleName();


  fpTrackingManager->SetStoreTrajectory(false); //Track default: no custom or G4Trajectories

  //-----------optical photon: store trajectory objects 

//   G4cout << "(JEC) PreUserTrackingAction (" << particleName 
//  	 << ") and DrawOptical = " << drawOpticalPhoton
//  	 << G4endl;

  if(!drawOpticalPhoton && (particleName == "opticalphoton") )return;

  if(drawOpticalPhoton && (particleName == "opticalphoton") ){

//     G4cout << "(JEC) PreUserTrackingAction: Optical--ParentID : " << aTrack->GetParentID()
// 	   << G4endl; 


     Trajectory* aTrajectory = new Trajectory(aTrack);  
     fpTrackingManager->SetTrajectory(aTrajectory);
     fpTrackingManager->SetStoreTrajectory(true); //(JEC) 14/12/05 keep it and delete it a posteriori 
                                                  //               only if it has not produced  a hit    

     TrackInformation* aInfo = new TrackInformation(aTrack);
     fpTrackingManager->SetUserTrackInformation(aInfo);

     return;

  }//eo optical photon  

  //-----------other particle: store trajectory objects

  // A priori some tracks are worth to be saved
  // is it a primary ?
  // is the process  in the set ? 
  // is the particle in the set ?
  // is it a gamma with enough energy 
  // due to lazy evaluation of the 'or' in C++ the order is important

  const G4VProcess* creatorProcess = aTrack->GetCreatorProcess();
  G4double thresholdTobeSaved = 0.*keV; //JEC FIXME put in the messenger

//   G4cout << "(JEC) PreUserTrackingAction (" << particleName 
// 	 << " ParentID " << aTrack->GetParentID();
//   if (creatorProcess!=0) G4cout << ") and Process Name " << creatorProcess->GetProcessName();
//   G4cout << G4endl;


  //JEC 20/2/06 debug: keep all particle for the moment
//   if( ( aTrack->GetParentID() == 0 ) || 
//       ( (creatorProcess!=0) && ProcessList.count(creatorProcess->GetProcessName()) ) || 
//       ( ParticleList.count(particleType->GetPDGEncoding()) ) || 
//       ( (particleType->GetPDGEncoding() == 22) && (aTrack->GetTotalEnergy() > thresholdTobeSaved) ) ) {

      //G4cout <<"Pre Tracking::particle = " << particleName 
      //       << " " << aTrack << G4endl;

        Trajectory* aTrajectory = new Trajectory(aTrack);  
        fpTrackingManager->SetTrajectory(aTrajectory);
        fpTrackingManager->SetStoreTrajectory(true); 
        return;

//  }//eo particles



}//PreUserTrackingAction

//---------------------------------------------------------------------------------------------------

void ELYSE::TrackingAction::PostUserTrackingAction(const G4Track* aTrack) {

  //-----------Check StoreTrajectory for particle : true or false?

  G4bool storetrajectory = fpTrackingManager->GetStoreTrajectory();
  if(!storetrajectory)return;

  G4ParticleDefinition*      particleType      = aTrack->GetDefinition();
  G4String                   particleName      = particleType->GetParticleName();
  
  //-----------opticalphoton 
  //---------------do not store it if it is not detected by the Tyvek

  if ( particleName == "opticalphoton" ) { 

       TrackInformation* aInfo = (TrackInformation*)(aTrack->GetUserInformation());

       //G4cout <<"PostTracking::opticalphoton = " 
       //       << particleName << " " << aTrack << " " << aInfo << G4endl;

       //------------- produced or not a hit: if not remove and return

       if ( !(aInfo->GetTrackStatus() & hitProduced) ) {
	 //JEC temporary           fpTrackingManager->SetStoreTrajectory(false);
           return; 
       }

  }//eo optical photon
      
  //-----------Get the trajectory from TrackingManager
  //---------------and fill in 

  //G4cout <<"PostTracking::particles = " 
  //       << particleName << " " << aTrack << G4endl;

  Trajectory *currentTrajectory = (Trajectory*)fpTrackingManager->GimmeTrajectory();

  G4ThreeVector      currentPosition = aTrack->GetPosition();
  G4VPhysicalVolume* currentVolume   = aTrack->GetVolume();
    
  currentTrajectory->SetStoppingPoint(currentPosition);
  currentTrajectory->SetStoppingVolume(currentVolume);
  currentTrajectory->SetSaveFlag(true); //For saving into Tuple (see EventAction) 

  //JEC to be fixed the above flag should not be needed now

}//PostUserTrackingAction




