{

  Int_t nLogSin22q13 = 21;
  Double_t logSin2Min = -4;
  Double_t logSin2Max = -2;
  Double_t logSin2BinWidth = 
    (logSin2Max - logSin2Min)/double(nLogSin22q13-1.);
  Double_t logSin2EdgeMax = logSin2Max + logSin2BinWidth/2.;
  Double_t logSin2EdgeMin = logSin2Min - logSin2BinWidth/2.;

  Int_t nDeltaCP  = 31;
  Double_t deltaMin = 0.; //rad/pi
  Double_t deltaMax =  2.;
  Double_t deltaBinWidth = (deltaMax - deltaMin)/double(nDeltaCP-1.);
  Double_t deltaEdgeMax = deltaMax + deltaBinWidth/2.;
  Double_t deltaEdgeMin = deltaMin - deltaBinWidth/2.;

  TLegend* leg = new TLegend(0.6,0.7,0.9,0.9);
  leg->SetTextFont(gStyle->GetTextFont());
  leg->SetTextSize(0.07);
  leg->SetFillColor(10);
  

  TCanvas* c1 = new TCanvas("c1","Contour",100,100,600,600);
  //  c1->SetGridx();
  // c1->SetGridy();
  c1->SetLogx();

  //  TH2D* hdum = new TH2D("hdum","3#sigma #theta_{13} discovery (#Delta #chi^{2}=9,1dof)",
  TH2D* hdum = new TH2D("hdum","",
			nLogSin22q13,TMath::Power(10.,logSin2Min),
			TMath::Power(10.,logSin2Max),
			nDeltaCP,deltaMin,deltaMax
			);
  hdum->SetYTitle("true #delta_{CP}/#pi");
  hdum->SetXTitle("true sin^{2}(2#theta_{13})");
  hdum->Draw();

  TPad *overlay = new TPad("overlay","",
			   gStyle->GetPadLeftMargin(),
			   gStyle->GetPadBottomMargin(),
			   1-gStyle->GetPadRightMargin(),
			   1-gStyle->GetPadTopMargin());
  overlay->SetFillStyle(4000);
  overlay->Draw();
  overlay->Range(logSin2Min,deltaMin,logSin2Max,deltaMax);


  TFile f1("./SPLThetaDiscovery-h0-o0.root");
  TTree* tree1 = (TTree*)f1.Get("SplGlb");
  TH2D* histo1 = new TH2D("histo1"," Theta vs Delta",
			  nLogSin22q13,logSin2EdgeMin,logSin2EdgeMax,
			  nDeltaCP,deltaEdgeMin,deltaEdgeMax
			  );

  tree1->Project(histo1->GetName(),"deltaCP/pi:TMath::Log10(pow(sin(2*theta13),2))","chi2");

  histo1->SetContour(1);
  histo1->SetContourLevel(0,9); //Chi2 for 1 dof and 3sigma
  histo1->SetLineColor(2); //red
  overlay->cd();
  histo1->Draw("CONT3 SAME");
  //  leg->AddEntry(histo1,"H^{tr} O^{tr}","l");
  leg->AddEntry(histo1,"True Octant","l");


  TPaveLabel* text = new TPaveLabel(-3.7,1.,-2.7,1.1,"true sin^{2}(#theta_{23})=0.4");
  text->SetBorderSize(0);
  text->SetFillColor(10);
  text->SetTextSize(1.0);
  text->Draw("SAME");

  TLatex* txt1 = new TLatex(-3.7,0.2,"3#sigma");
  txt1->SetTextSize(0.1);
  txt1->Draw();



//   TFile f2("./SPLThetaDiscovery-h1-o0.root");
//   TTree* tree2 = (TTree*)f2.Get("SplGlb");
//   TH2D* histo2 = new TH2D("histo2"," Theta vs Delta",
// 			  nLogSin22q13,logSin2EdgeMin,logSin2EdgeMax,
// 			  nDeltaCP,deltaEdgeMin,deltaEdgeMax
// 			  );
//   tree2->Project(histo2->GetName(),"deltaCP/pi:TMath::Log10(pow(sin(2*theta13),2))","chi2");

//   histo2->SetContour(1);
//   histo2->SetContourLevel(0,9); //Chi2 for 1 dof and 3sigma
//   histo2->SetLineStyle(2); //dashed
//   histo2->SetLineColor(4); //blue
//   overlay->cd();
//   histo2->Draw("CONT3 SAME");
//   leg->AddEntry(histo2,"H^{wr} O^{tr}","l");


  TFile f3("./SPLThetaDiscovery-h0-o1.root");
  TTree* tree3 = (TTree*)f3.Get("SplGlb");
  TH2D* histo3 = new TH2D("histo3"," Theta vs Delta",
			  nLogSin22q13,logSin2EdgeMin,logSin2EdgeMax,
			  nDeltaCP,deltaEdgeMin,deltaEdgeMax
			  );
  tree3->Project(histo3->GetName(),"deltaCP/pi:TMath::Log10(pow(sin(2*theta13),2))","chi2");

  histo3->SetContour(1);
  histo3->SetContourLevel(0,9); //Chi2 for 1 dof and 3sigma
  histo3->SetLineStyle(2); //dashed  
  histo3->SetLineColor(4); //blue
  overlay->cd();
  histo3->Draw("CONT3 SAME");
  leg->AddEntry(histo3,"Fake Octant","l");
  //  leg->AddEntry(histo3,"H^{tr} O^{wr}","l");


//   TFile f4("./SPLThetaDiscovery-h1-o1.root");
//   TTree* tree4 = (TTree*)f4.Get("SplGlb");
//   TH2D* histo4 = new TH2D("histo4"," Theta vs Delta",
// 			  nLogSin22q13,logSin2EdgeMin,logSin2EdgeMax,
// 			  nDeltaCP,deltaEdgeMin,deltaEdgeMax
// 			  );
//   tree4->Project(histo4->GetName(),"deltaCP/pi:TMath::Log10(pow(sin(2*theta13),2))","chi2");

//   histo4->SetContour(1);
//   histo4->SetContourLevel(0,9); //Chi2 for 1 dof and 3sigma
//   histo4->SetLineStyle(2); //dashed
//   histo4->SetLineColor(5); //yellow
//   overlay->cd();
//   histo4->Draw("CONT3 SAME");
//   leg->AddEntry(histo4,"H^{wr} O^{wr}","l");



  leg->Draw("SAME");
  overlay->Update();




  //  TCanvas c2;
  //histo1->Draw("SURF");



}
