{

    Int_t nLogSin22q13 = 41;
   Double_t logSin2Min = -4;
   Double_t logSin2Max = -1;
   Double_t logSin2BinWidth = 
     (logSin2Max - logSin2Min)/double(nLogSin22q13-1.);
   Double_t logSin2EdgeMax = logSin2Max + logSin2BinWidth/2.;
   Double_t logSin2EdgeMin = logSin2Min - logSin2BinWidth/2.;

   Int_t nDeltaCP  = 61;
   Double_t deltaMin = 0.; //degree
   Double_t deltaMax =  180.;
   Double_t deltaBinWidth = (deltaMax - deltaMin)/double(nDeltaCP-1.);
   Double_t deltaEdgeMax = deltaMax + deltaBinWidth/2.;
   Double_t deltaEdgeMin = deltaMin - deltaBinWidth/2.;



 

  TCanvas* c1 = new TCanvas("c1","Contour",100,100,600,600);
  c1->SetGridx();
  c1->SetGridy();
  c1->SetLogx();

  TH2D* hdum = new TH2D("hdum","#delta_{CP} 3#sigma discovery",
			nLogSin22q13,TMath::Power(10.,logSin2Min),TMath::Power(10.,logSin2Max),
			nDeltaCP,deltaMin,deltaMax
			);
  hdum->SetYTitle("#delta_{CP} (deg)");
  hdum->SetXTitle("sin^{2}(2#theta_{13})");
  hdum->Draw();

  TPad *overlay = new TPad("overlay","",
			   gStyle->GetPadLeftMargin(),
			   gStyle->GetPadBottomMargin(),
			   1-gStyle->GetPadRightMargin(),
			   1-gStyle->GetPadTopMargin());
  overlay->SetFillStyle(4000);
  overlay->Draw();
  overlay->Range(logSin2Min,deltaMin,logSin2Max,deltaMax);


  TFile f1("./OptiFlux/SPLDeltaCorr3.root");
  TTree* tree1 = (TTree*)f1.Get("SplGlb");
  TH2D* histo1 = new TH2D("histo1"," Theta vs Delta",
			  nLogSin22q13,logSin2EdgeMin,logSin2EdgeMax,
			  nDeltaCP,deltaEdgeMin,deltaEdgeMax
			  );

  tree1->Project(histo1->GetName(),"deltaCP/pi*180.:TMath::Log10(pow(sin(2*theta13),2))","chi2");

  histo1->SetContour(1);
  histo1->SetContourLevel(0,9); //Chi2 for 1 dof and 3sigma
  histo1->SetLineColor(2); //red
  overlay->cd();
  histo1->Draw("CONT3 SAME");



  TFile f2("./SPLDeltaCorrOldFlux3.root");
  TTree* tree2 = (TTree*)f2.Get("SplGlb");
  TH2D* histo2 = new TH2D("histo2"," Theta vs Delta",
			  nLogSin22q13,logSin2EdgeMin,logSin2EdgeMax,
			  nDeltaCP,deltaEdgeMin,deltaEdgeMax
			  );
  tree2->Project(histo2->GetName(),"deltaCP/pi*180.:TMath::Log10(pow(sin(2*theta13),2))","chi2");

  histo2->SetContour(1);
  histo2->SetContourLevel(0,9); //Chi2 for 1 dof and 3sigma
  histo2->SetLineColor(4); //blue
  overlay->cd();
  histo2->Draw("CONT3 SAME");




  overlay->Update();



}
