{
  
  int nSin2q23;
  double sin2Min;
  double sin2Max;

  int nDm31;
  double dm31Min;
  double dm31Max;
  
  std::ifstream fileDataCard;
  fileDataCard.open("./dm31th23.data");
  std::string DUMMYSTR; //comment string of the variables
  
  std::string ROOTFILENAME;

  double DUMMYVAR; //not used variable

  fileDataCard >> DUMMYSTR >> DUMMYVAR;  
  fileDataCard >> DUMMYSTR >> DUMMYVAR;  
  fileDataCard >> DUMMYSTR >> DUMMYVAR;  
  fileDataCard >> DUMMYSTR >> DUMMYVAR;  
  fileDataCard >> DUMMYSTR >> DUMMYVAR;  
  fileDataCard >> DUMMYSTR >> DUMMYVAR;  
  fileDataCard >> DUMMYSTR >> ROOTFILENAME;  
  ROOTFILENAME += ".root";
  std::cout << DUMMYSTR <<ROOTFILENAME  << std::endl; 

  fileDataCard >> DUMMYSTR >> nDm31;  
  std::cout << DUMMYSTR << nDm31  << std::endl; 
  fileDataCard >> DUMMYSTR >> nSin2q23;  
  std::cout << DUMMYSTR << nSin2q23 << std::endl; 

  fileDataCard >> DUMMYSTR >> dm31Min;  
  std::cout << DUMMYSTR << dm31Min << std::endl; 
  fileDataCard >> DUMMYSTR >> dm31Max;  
  std::cout << DUMMYSTR <<  dm31Max << std::endl; 

  fileDataCard >> DUMMYSTR >> sin2Min;  
  std::cout << DUMMYSTR <<  sin2Min << std::endl; 
  fileDataCard >> DUMMYSTR >> sin2Max;  
  std::cout << DUMMYSTR <<  sin2Max << std::endl; 


  Double_t sin2BinWidth = (sin2Max - sin2Min)/double(nSin2q23-1.);
  Double_t sin2EdgeMax = sin2Max + sin2BinWidth/2.;
  Double_t sin2EdgeMin = sin2Min - sin2BinWidth/2.;

  Double_t dm31BinWidth = (dm31Max - dm31Min)/double(nDm31-1.);
  Double_t dm31EdgeMax = dm31Max + dm31BinWidth/2.;
  Double_t dm31EdgeMin = dm31Min - dm31BinWidth/2.;

  TLegend* leg = new TLegend(0.4,0.7,0.9,0.9);
  leg->SetTextFont(gStyle->GetTextFont());
  leg->SetTextSize(0.07);
  leg->SetFillColor(10);
  

  TCanvas* c1 = new TCanvas("c1","Contour",100,100,600,600);
  c1->SetGridx();
  c1->SetGridy();

  TH2D* hdum = new TH2D("hdum","",
			nSin2q23,sin2Min,sin2Max,
			nDm31,dm31Min,dm31Max
			);
  hdum->SetYTitle("#Delta m^{2}_{31} (eV^{2})");
  hdum->SetXTitle("sin^{2}(#theta_{23})");
  TGaxis::SetMaxDigits(3);
  hdum->Draw();

  TPad *overlay = new TPad("overlay","",
			   gStyle->GetPadLeftMargin(),
			   gStyle->GetPadBottomMargin(),
			   1-gStyle->GetPadRightMargin(),
			   1-gStyle->GetPadTopMargin());
  overlay->SetFillStyle(4000);
  overlay->Draw();
  overlay->Range(sin2Min,dm31Min,sin2Max,dm31Max);


  TFile f1(ROOTFILENAME.data());
  TTree* tree1 = (TTree*)f1.Get("SplGlb");
  TH2D* histo1 = new TH2D("histo1","Dm_{31} vs sin^{2} th23",
			  nSin2q23,sin2EdgeMin,sin2EdgeMax,
			  nDm31,dm31EdgeMin,dm31EdgeMax
			  );

  tree1->Project(histo1->GetName(),"dm31:pow(sin(theta23),2)","chi2");

  histo1->SetContour(1);
  histo1->SetContourLevel(0,1.);  //Chi2 for 1 dof and 1sigma
  //histo1->SetContourLevel(0,4); //Chi2 for 1 dof and 2sigma
  //histo1->SetContourLevel(0,9); //Chi2 for 1 dof and 3sigma
  histo1->SetLineColor(2); //red
  overlay->cd();
  histo1->Draw("CONT3 SAME");
  leg->AddEntry(histo1,"1#sigma 5yrs (+)","l");


//   TH2D* h1bis = histo1->Clone("h1bis");
//   h1bis->SetContour(1);
//   h1bis->SetContourLevel(0,9); //Chi2 for 1 dof and 3sigma
//   overlay->cd();
//   h1bis->SetLineColor(4); //blue
//   h1bis->Draw("CONT3 SAME");
//   leg->AddEntry(h1bis,"1#sigma 5yrs (+)","l");


  int n0 = 1;
  //2sigma
  //sin^2(theta23) = 0.44 * (1+0.41-0.22)
  //dm^2_31        = 2.4 * (1 +0.21 -0.26) 10^-3 eV^2
  //3sigma errors
  float sin2th0[n0]      = {0.44};
  float dm310[n0]        = {2.4e-3};
  float esin2th0_inf[n0] = {0.115};
  float esin2th0_sup[n0] = {0.211};
  float edm310_inf[n0]   = {0.875e-3};
  float edm310_sup[n0]   = {0.792e-3};


  
//   TGraphAsymmErrors* point = new TGraphAsymmErrors(n0,sin2th0,dm310,
// 						   esin2th0_inf,esin2th0_sup,
// 						   edm310_inf,edm310_sup);
  
//   point->SetMarkerColor(4);
//   point->SetMarkerStyle(21);
//  leg->AddEntry(point,"3#sigma Global Adjust.","p");

  TMarker* point = new TMarker(sin2th0[0],dm310[0],21);
  point->Draw("SAME P");
  


//   TPaveLabel* text = new TPaveLabel(-3.7,1.,-2.7,1.1,"true sin^{2}(#theta_{23})=0.4");
//   text->SetBorderSize(0);
//   text->SetFillColor(10);
//   text->SetTextSize(1.0);
//   text->Draw("SAME");

//   TLatex* txt1 = new TLatex(-3.7,0.2,"3#sigma");
//   txt1->SetTextSize(0.1);
//   txt1->Draw();



  leg->Draw("SAME");
  overlay->Update();




  TCanvas c2;
  histo1->Draw("SURF");



}
