{
 
  TCanvas* c1 = new TCanvas("c1","SPL Flux",100,100,600,600);
  c1->SetLogy();

  TLegend* leg = new TLegend(0.20,0.20,0.45,0.55);
  leg->SetTextFont(gStyle->GetTextFont());
  leg->SetTextSize(0.04);



  TH1D* hdum = new TH1D("hdum","Rates 5yrs (+)",5,0.08,1.08);
  hdum->SetMaximum(1e3);
  hdum->SetMinimum(1e-3);
  hdum->SetXTitle("E_{#nu} (GeV)");
  hdum->SetYTitle("Number of Events");
  hdum->Draw();
  
  TTree T1("t1","SPL Rate for 5yrs +");
  T1.ReadFile("./rate5+.dat","ene/F:numuCC/F:nueB/F:nubare/F:pi0/F:nue1d/F:nue3d/F");

  T1.Draw("ene>>hnueB(5,0.08,1.08)","nueB","SAME");

  T1.SetLineColor(6);
  T1.Draw("ene>>hnumuCC(5,0.08,1.08)","numuCC","SAME");
  
  T1.SetLineColor(7);
  T1.Draw("ene>>hnubare(5,0.08,1.08)","nubare","SAME");
  
  T1.SetLineColor(3);
  T1.Draw("ene>>hpi0(5,0.08,1.08)","pi0","SAME");

  T1.SetLineColor(4);
  T1.Draw("ene>>hnue3d(5,0.08,1.08)","nue3d","SAME");

  T1.SetLineColor(4);
  T1.SetLineStyle(2);
  T1.Draw("ene>>hnue1d(5,0.08,1.08)","nue1d","SAME");
  

  leg->AddEntry(hnue3d,"#nu_{e} (#theta_{13} = 3^{o})","l");
  leg->AddEntry(hnue1d,"#nu_{e} (#theta_{13} = 1^{o})","l");
  leg->AddEntry(hnueB,"#nu_{e} Beam","l");
  leg->AddEntry(hpi0,"#pi^{0} (NC)","l");
  leg->AddEntry(hnumuCC,"#mu missId ","l");
  leg->AddEntry(hnubare,"#bar{#nu_{e}}","l");
  leg->Draw();

}
