{

  gROOT->LoadMacro("TDSyst.C++");
  TCanvas* c1 = new TCanvas("c1","Contour",100,100,600,600);
  c1->SetGridx();
  c1->SetGridy();
  c1->SetLogy();

  TH2D* hdum = new TH2D("hdum","Theta vs Delta",41,-180,180,31,1e-4,1e-1);
  hdum->SetXTitle("#delta_{CP} (deg)");
  hdum->SetYTitle("sin^{2}(2#theta_{13})");
  hdum->Draw();

  TPad *overlay = new TPad("overlay","",
			   gStyle->GetPadLeftMargin(),
			   gStyle->GetPadBottomMargin(),
			   1-gStyle->GetPadRightMargin(),
			   1-gStyle->GetPadTopMargin());
  overlay->SetFillStyle(4000);
  overlay->Draw();
  overlay->Range(-180.,-4,180.,-1);

  //Original
  TFile* file1 = new TFile("./SPLDeltaTheta2+8OldFluxCorr.root");
  TTree* tree1 = (TTree*)file1->Get("SplGlb");
  TDSyst* comp1 = new TDSyst(tree1,"h1");
  comp1->Loop();

  TH2D* h1 = comp1->GetHisto();
  h1->SetContour(1);
  h1->SetContourLevel(0,4.605); //Chi2 for 2 dof and 90% CL
  //  h1->SetLineStyle(2);
  h1->SetLineColor(4); //blue
  overlay->cd();
  h1->Draw("CONT3 SAME");
  overlay->Update();

  //Comp
  TFile* file2 = new TFile("./OptiFlux/SPLDeltaThetaSens.root");
  TTree* tree2 = (TTree*)file2->Get("SplGlb");
  TDSyst* comp2 = new TDSyst(tree2,"h2");
  comp2->Loop();

  TH2D* h2 = comp2->GetHisto();
  h2->SetContour(1);
  h2->SetContourLevel(0,4.605); //Chi2 for 2 dof and 90% CL
  h2->SetLineColor(2); //red
  overlay->cd();
  h2->Draw("CONT3 SAME");
  overlay->Update();

  //Comp
  TFile* file3 = new TFile("./OptiFlux/SPLDeltaThetaRateCorr.root");
  TTree* tree3 = (TTree*)file3->Get("SplGlb");
  TDSyst* comp3 = new TDSyst(tree3,"h3");
  comp3->Loop();

  TH2D* h3 = comp3->GetHisto();
  h3->SetContour(1);
  h3->SetContourLevel(0,4.605); //Chi2 for 2 dof and 90% CL
  h3->SetLineColor(6); //blue
  overlay->cd();
  h3->Draw("CONT3 SAME");
  overlay->Update();

}
