//std
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <cmath>
#include <fstream>
#include <iostream>

//Globes
#include <globes/globes.h>

// AIDA :
#include <AIDA/IAnalysisFactory.h>
#include <AIDA/ITreeFactory.h>
#include <AIDA/IHistogramFactory.h>
#include <AIDA/ITree.h>
#include <AIDA/ITupleFactory.h>
#include <AIDA/ITuple.h>



#define TH12 ( asin(sqrt(0.3)) )
#define TH23 ( asin(sqrt(0.6)) )
#define TH13 ( 0.5 * asin(sqrt(0.03)) )

#define DELTA (-0.85 * M_PI )

#define DMQ21 8.1e-5
#define DMQ31 2.2e-3


int WRONG_TH23, WRONG_HIER;


bool test_th23(glb_params fit_values) {
  double fit_th23 = glbGetOscParams(fit_values, GLB_THETA_23);
  
  // testing if fit_th23 is at the same side as the true value
  
  return  ( 
	   (WRONG_TH23 == 0 && 
	    (TH23 > M_PI/4. && fit_th23 > M_PI/4.) ||
	    (TH23 < M_PI/4. && fit_th23 < M_PI/4.))
	   ||
	   (WRONG_TH23 == 1 && 
	    (TH23 > M_PI/4. && fit_th23 < M_PI/4.) ||
	    (TH23 < M_PI/4. && fit_th23 > M_PI/4.))
	   );
}//same_th23

//---------------------------------------------------------------------
bool test_hier(glb_params fit_values) {
  double fit_dmq = glbGetOscParams(fit_values, GLB_DM_ATM);
  
  // testing if fit_dmq has the same sign as the true value
  return ( 
	  (WRONG_HIER == 0 && fit_dmq * DMQ31 > 0) || 
	  (WRONG_HIER == 1 && fit_dmq * DMQ31 < 0) 
	  );
}//same_hier

//---------------------------------------------------------------------

bool test(glb_params fit_values) {    
  return test_th23(fit_values) && test_hier(fit_values);
}


/**************************************/
/*           main                     */
/**************************************/

int main(int argc, char *argv[])
{
  if(argc != 3){
    std::cerr << "usage:" << argv[0] << "WRONG_TH23 WRONG_HIER" << std::endl;
    std::cerr<< "WRONG_* = '1' for wrong * and '0' for right *" << std::endl;
    return 0;
  }
  
  if(sscanf(argv[1], "%d", &WRONG_TH23) != 1 ||
     (WRONG_TH23 != 1 && WRONG_TH23 != 0) ||
     sscanf(argv[2], "%d", &WRONG_HIER) != 1 ||
     (WRONG_HIER != 1 && WRONG_HIER != 0)){
    std::cerr<< "cannot read parameters" << std::endl;
    return 0;
  }
 
  //init AIDA for Histo/Tuple
  AIDA::IAnalysisFactory* aida = AIDA_createAnalysisFactory();
  if(!aida) {
    std::cerr  << " AIDA not found." << std::endl;
    return 0;
  }

  //ROOT tree :
  AIDA::ITreeFactory* treeFactory = aida->createTreeFactory();
  std::string opts = "export=root";
  AIDA::ITree* fTree = 
    treeFactory->create("degener.root","root",false,true,opts);
  delete treeFactory;

 //Booking Tuple
  AIDA::ITupleFactory* tf = aida->createTupleFactory(*fTree);

  int NumberOfColumn = 7;
  std::vector<std::string> column(NumberOfColumn);
  const char* c_column[] = {"theta12", "theta13", "theta23", 
			    "deltaCP", "dm21", "dm31", 
			    "chi2"};
  std::vector<std::string> coltype(NumberOfColumn);
  const char* c_coltype[] = {"double","double","double",
			     "double","double","double",
			     "double"};
  for (int icol = 0; icol<NumberOfColumn; ++icol) {
    column[icol]  = c_column[icol];
    coltype[icol] = c_coltype[icol];
  }

  AIDA::ITuple* myTuple = 
    tf->create("SplGlb","Theta23 [0,90deg]:Dm31>0 scan",column,coltype);
  
 
  //Init Globes
  glbInit(argv[0]);
  glbInitExperiment("../data/SPL.glb", 
		    &glb_experiment_list[0], 
		    &glb_num_of_exps);

  // true values (reference for future Chi2 computations) 
  glb_params true_values = glbAllocParams();
  glbDefineParams(true_values, TH12, TH13, TH23, DELTA, DMQ21, DMQ31);
  std::cout << "The Initial True_values" << std::endl;
  glbPrintParams(stdout,true_values);
  
  glbSetOscillationParameters(true_values);  
  glbSetRates();
  
  // set Starting Values (1st trial)
  glb_params start_values = glbAllocParams();
  glbDefineParams(start_values, TH12, TH13, TH23, DELTA, DMQ21, DMQ31);
    
  if(WRONG_HIER == 1)
    glbSetOscParams(start_values, -DMQ31+DMQ21, GLB_DM_ATM);

  if(WRONG_TH23 == 1)
    glbSetOscParams(start_values, 0.5*M_PI - TH23, GLB_THETA_23);

  glbSetStartingValues(start_values);
  std::cout << "The Starting values 1st trail" << std::endl;
  glbPrintParams(stdout,start_values);
  glbFreeParams(start_values);

  
  // init test values
  glb_params test_values = glbAllocParams();
  glbDefineParams(test_values, TH12, TH13, TH23, DELTA, DMQ21, DMQ31);
  
  if(WRONG_HIER == 1)
    glbSetOscParams(test_values, -DMQ31+DMQ21, GLB_DM_ATM);
  
  if(WRONG_TH23 == 1)
    glbSetOscParams(test_values, 0.5*M_PI - TH23, GLB_THETA_23);
  std::cout << "The Test_values" << std::endl;
  glbPrintParams(stdout,test_values);

  glb_params fit_values = glbAllocParams(); //final minimization

  // Set theta23 error very low to constraint the minimizer in the right octant
  // input errors
  glb_params input_errors = glbAllocParams();
  glbDefineParams(input_errors, 
		  TH12*0.1, 0., TH23*0.05, 0., 
		  DMQ21*0.05, fabs(DMQ31)*0.05);
  glbSetDensityParams(input_errors, 0.05, GLB_ALL);
  glbSetInputErrors(input_errors);

  //double err_fit_theta12 = glbGetOscParams(input_errors, GLB_THETA_12);
  //double err_fit_theta13 = glbGetOscParams(input_errors, GLB_THETA_13);
  double err_fit_theta23 = glbGetOscParams(input_errors, GLB_THETA_23);
  //double err_fit_deltaCP = glbGetOscParams(input_errors, GLB_DELTA_CP);
  //double err_fit_dmSol   = glbGetOscParams(input_errors, GLB_DM_SOL);
  double err_fit_dmAtm   = glbGetOscParams(input_errors, GLB_DM_ATM);
  std::cout << "Theta23 error " << err_fit_theta23/TH23 
	    << " and Dm31 error " << err_fit_dmAtm/fabs(DMQ31) 
	    << std::endl;
  
  static const int NDM31 =26;  
  static const int NTH23 =91;
  static const double DM31MIN = 1e-3;
  static const double DM31MAX = 5e-3;
  static const double THETA23MIN =  0.0; //degree
  static const double THETA23MAX = 90.0;    

  std::cout << "Start to loop...." << std::endl;

  double res;
  double fit_theta12, fit_theta13,fit_theta23,fit_deltaCP,fit_dmSol,fit_dmAtm;
  double dm31cur, theta23cur;

  
  //set a DELTA_CP test value
  glbSetOscParams(test_values,-0.12*M_PI,GLB_DELTA_CP);
  glbSetOscParams(test_values,0.5*asin(sqrt(0.025)),GLB_THETA_13);


  //Scan in theta23 and Dm31 to find minimum Chi2
  for(int j = 0; j < NDM31; j++)
  {
    dm31cur = DM31MIN 
      + (DM31MAX-DM31MIN) * double(j)/double(NDM31-1);

    glbSetOscParams(test_values, dm31cur, GLB_DM_ATM);

    for(int k = 0; k < NTH23; k++)
    {      
      theta23cur = THETA23MIN
	+ (THETA23MAX - THETA23MIN) * double(k)/double(NTH23-1);
      
      std::cout << "delta j:" << j << " theta13 k:" << k << std::endl;
      
      glbSetOscParams(test_values,theta23cur*M_PI/180.0, GLB_THETA_23);
      

      //Find Chi2 associated
      res = glbChiSys(test_values,0,GLB_ALL);
      

      fit_theta12 = glbGetOscParams(test_values, GLB_THETA_12);
      fit_theta13 = glbGetOscParams(test_values, GLB_THETA_13);
      fit_theta23 = glbGetOscParams(test_values, GLB_THETA_23);
      fit_deltaCP = glbGetOscParams(test_values, GLB_DELTA_CP);
      fit_dmSol   = glbGetOscParams(test_values, GLB_DM_SOL);
      fit_dmAtm   = glbGetOscParams(test_values, GLB_DM_ATM);

//       if (!test(fit_values)) {
// 	std::cout << "Problem at (j,k): " << j << " , " << k << std::endl;
// 	std::cout << "Theta_12 " <<  fit_theta12 << " "
// 		  << "Theta_13 " <<  fit_theta13 << " "
// 		  << "Theta_23 " <<  fit_theta23*180./M_PI << " "
// 		  << "Delta_CP " <<  fit_deltaCP << " "
// 		  << "DM_21    " <<  fit_dmSol   << " "
// 		  << "DM_31    " <<  fit_dmAtm   << " "
// 		  << "Chi2 (mini) " << res
// 		  << std::endl;
// 	continue;
//       }

      
//       std::cout << "Theta_12 " <<  fit_theta12 << " "
//  		<< "Theta_13 " <<  fit_theta13 << " "
// 		<< "Theta_23 " <<  fit_theta23*180./M_PI << " "
// 		<< "Delta_CP " <<  fit_deltaCP << " "
// 		<< "DM_21    " <<  fit_dmSol   << " "
// 		<< "DM_31    " <<  fit_dmAtm   << " "
// 		<< "Chi2 (mini) " << res
// 		<< std::endl;       


      myTuple->fill(0,fit_theta12);
      myTuple->fill(1,fit_theta13);
      myTuple->fill(2,fit_theta23);
      myTuple->fill(3,fit_deltaCP);
      myTuple->fill(4,fit_dmSol);
      myTuple->fill(5,fit_dmAtm);
      myTuple->fill(6,res);
      myTuple->addRow();

      

    }//Loop on Theta13
  }//Loop on DeltaCP
  
  glbFreeParams(true_values);
  glbFreeParams(test_values);
  glbFreeParams(fit_values);


  //save Tuple
  fTree->commit();
  delete fTree;
  
  delete aida;
  return 0;
}
    




