//std
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <cmath>
#include <fstream>
#include <iostream>

//Globes
#include <globes/globes.h>

// AIDA :
#include <AIDA/IAnalysisFactory.h>
#include <AIDA/ITreeFactory.h>
#include <AIDA/IHistogramFactory.h>
#include <AIDA/ITree.h>
#include <AIDA/ITupleFactory.h>
#include <AIDA/ITuple.h>


/*
  Discovery plot dm31 and theta_13
  Theta_13=0 and Delta=0 for the true value of the reference experiment
  use glbChiNP to marginalized other all parameters except of 
  the current dm31 and theta (delta=0 is also fixed)*/

#define TH12 ( 0.5 * asin(sqrt(0.82)) )
#define TH23 ( M_PI/4.0 )

#define TH13   0.0
#define DELTA  0.0 

#define DMQ21 8.2e-5
#define DMQ31 2.5e-3


/**************************************/
/*           main                     */
/**************************************/

int main(int argc, char *argv[])
{
  //init AIDA for Histo/Tuple
  AIDA::IAnalysisFactory* aida = AIDA_createAnalysisFactory();
  if(!aida) {
    std::cerr  << " AIDA not found." << std::endl;
    return 0;
  }

  //ROOT tree :
  AIDA::ITreeFactory* treeFactory = aida->createTreeFactory();
  std::string opts = "export=root";
  AIDA::ITree* fTree = 
    treeFactory->create("SPLDmThetaCorr.root","root",false,true,opts);
  delete treeFactory;

 //Booking Tuple
  AIDA::ITupleFactory* tf = aida->createTupleFactory(*fTree);

  int NumberOfColumn = 7;
  std::vector<std::string> column(NumberOfColumn);
  const char* c_column[] = {"theta12", "theta13", "theta23", 
			    "deltaCP", "dm21", "dm31", 
			    "chi2"};
  std::vector<std::string> coltype(NumberOfColumn);
  const char* c_coltype[] = {"double","double","double",
			     "double","double","double",
			     "double"};
  for (int icol = 0; icol<NumberOfColumn; ++icol) {
    column[icol]  = c_column[icol];
    coltype[icol] = c_coltype[icol];
  }

  AIDA::ITuple* myTuple = 
    tf->create("SplGlb","dm31 - theta13",column,coltype);
  
 
  //Init Globes
  glbInit(argv[0]);
  glbInitExperiment("../data/SPL.glb", 
		    &glb_experiment_list[0], 
		    &glb_num_of_exps);

  // input errors
  glb_params input_errors = glbAllocParams();
  glbDefineParams(input_errors, 
		  TH12*0.05, 0., TH23*0.30, 0., 
		  DMQ21*0.05, fabs(DMQ31)*0.30);
  glbSetDensityParams(input_errors, 0.05, GLB_ALL);
  glbSetInputErrors(input_errors);

#define NDM 41  
#define LOG10DMMIN -3.3
#define LOG10DMMAX -2.0

#define NTH 41
#define LOG10THMIN -3.3
#define LOG10THMAX -2.0


  glb_params true_values = glbAllocParams();
  glb_params start_values = glbAllocParams();
  glb_params test_values = glbAllocParams();

  //Projection. Theta13-Dm31 (et deltaCP fixed also)
  glb_projection proj = glbAllocProjection();
  glbDefineProjection(proj, GLB_FREE, GLB_FIXED,GLB_FREE,
		            GLB_FIXED, GLB_FREE, GLB_FIXED);
  glbSetProjection(proj);

  std::cout << "Start to loop...." << std::endl;


  double res;
  double fit_theta12, fit_theta13,fit_theta23,fit_deltaCP,fit_dmSol,fit_dmAtm;
  double log10s2, sq2th, th;
  double log10dm, dm;

  for(int j = 0; j < NDM; j++)
  {
    //scan de DM31
    log10dm = LOG10DMMIN + (LOG10DMMAX -  LOG10DMMIN) * double(j) / (NDM-1);
    dm = pow(10.,log10dm);


    for(int k = 0; k < NTH; k++)
    {      
      //scan de THETA13
      log10s2 = LOG10THMIN + (LOG10THMAX-LOG10THMIN) * double(k) / (NTH-1);
      sq2th = pow(10.,log10s2);
      th = 0.5 * asin(sqrt(sq2th));
      
      std::cout << "dm31 j:" << j << " theta13 k:" << k << std::endl;
      glbDefineParams(true_values, TH12, th, TH23, DELTA, DMQ21, dm);
      glbSetOscillationParameters(true_values);  
      glbSetRates();


      // set Starting Values
      glbDefineParams(start_values, TH12, th, TH23, DELTA, DMQ21, dm);
      glbSetStartingValues(start_values);
      
      // init test values with Theta13=0
      glbDefineParams(test_values, TH12, TH13, TH23, DELTA, DMQ21, dm);
      // check whether the data can be fitted with Theta13=0 (delta=0 fixed)
      res = glbChiNP(test_values,NULL,GLB_ALL);

      //store the true_values theta13,dm31, the other variables are there
      //just for compatibility for the Tuple definition
      fit_theta12 = glbGetOscParams(true_values, GLB_THETA_12);
      fit_theta13 = glbGetOscParams(true_values, GLB_THETA_13);
      fit_theta23 = glbGetOscParams(true_values, GLB_THETA_23);
      fit_deltaCP = glbGetOscParams(true_values, GLB_DELTA_CP);
      fit_dmSol   = glbGetOscParams(true_values, GLB_DM_SOL);
      fit_dmAtm   = glbGetOscParams(true_values, GLB_DM_ATM);


//       std::cout << "Theta_12(rad) " <<  fit_theta12 << " "
//  		<< "Theta_13(rad) " <<  fit_theta13 << " "
// 		<< "Theta_23(deg) " <<  fit_theta23*180./M_PI << " "
// 		<< "Delta_CP(deg) " <<  fit_deltaCP*180./M_PI << " "
// 		<< "DM_21    " <<  fit_dmSol   << " "
// 		<< "DM_31    " <<  fit_dmAtm   << " "
// 		<< "Chi2 (fin) " << res
// 		<< std::endl;       


      //Store in the Tuple
      myTuple->fill(0,fit_theta12);
      myTuple->fill(1,fit_theta13);
      myTuple->fill(2,fit_theta23);
      myTuple->fill(3,fit_deltaCP);
      myTuple->fill(4,fit_dmSol);
      myTuple->fill(5,fit_dmAtm);
      myTuple->fill(6,res);
      myTuple->addRow();

      

    }//Loop on Theta13
  }//Loop on Dm31
  
  //free GLoBES arrays
  glbFreeParams(true_values);
  glbFreeParams(test_values);
  glbFreeParams(start_values);

  //save Tuple
  fTree->commit();
  delete fTree;
  
  delete aida;
  return 0;
}
    




