//std
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <cmath>
#include <fstream>
#include <iostream>

//Globes
#include <globes/globes.h>

// AIDA :
#include <AIDA/IAnalysisFactory.h>
#include <AIDA/ITreeFactory.h>
#include <AIDA/IHistogramFactory.h>
#include <AIDA/ITree.h>
#include <AIDA/ITupleFactory.h>
#include <AIDA/ITuple.h>


/*
  Mesaurements of dm31 and theta_23
  use glbChiNP to marginalized other all parameters except of 
  the current dm31 and theta23
  
  21/7/05 JEC creation
  22/7/05 JEC laod Data Cards
*/

//oscillation parameters
float TH12;
float TH23;
float TH13;
float DELTA;
float DMQ21;
float DMQ31;

//Binning to scan in Dm^2_31 and Sin^2(theta23)
int NDM;  
float DMMIN;
float DMMAX;
int NTH;
float SQ2THMIN;
float SQ2THMAX;


/**************************************/
/*           main                     */
/**************************************/

int main(int argc, char *argv[])
{

  //Process data card file
  std::string ROOTDIR = getenv("GLBFREJUSROOT");
  std::string DATACARD;
  DATACARD = ROOTDIR + "/run/dm31th23.data"; 
  std::ifstream fileDataCard;
  std::cout << "Open DataCard file : " << DATACARD <<std::endl;
  fileDataCard.open(DATACARD.data());
  std::string DUMMYSTR; //comment string of the variables

  std::string ROOTFILENAME;


  fileDataCard >> DUMMYSTR >> TH12;  
  std::cout << DUMMYSTR << TH12 << std::endl; 
  fileDataCard >> DUMMYSTR >> TH23;  
  std::cout << DUMMYSTR << TH23 << std::endl; 
  fileDataCard >> DUMMYSTR >> TH13;  
  std::cout << DUMMYSTR << TH13 << std::endl; 
  fileDataCard >> DUMMYSTR >> DELTA; 
  std::cout << DUMMYSTR << DELTA << std::endl; 
  fileDataCard >> DUMMYSTR >> DMQ21;  
  std::cout << DUMMYSTR << DMQ21 << std::endl; 
  fileDataCard >> DUMMYSTR >> DMQ31;  
  std::cout << DUMMYSTR << DMQ31 << std::endl; 

  fileDataCard >> DUMMYSTR >> ROOTFILENAME;  
  ROOTFILENAME += ".root";
  std::cout << DUMMYSTR <<ROOTFILENAME  << std::endl; 

  fileDataCard >> DUMMYSTR >> NDM;  
  std::cout << DUMMYSTR << NDM  << std::endl; 
  fileDataCard >> DUMMYSTR >> NTH;  
  std::cout << DUMMYSTR << NTH  << std::endl; 

  fileDataCard >> DUMMYSTR >> DMMIN;  
  std::cout << DUMMYSTR << DMMIN  << std::endl; 
  fileDataCard >> DUMMYSTR >> DMMAX;  
  std::cout << DUMMYSTR << DMMAX  << std::endl; 

  fileDataCard >> DUMMYSTR >> SQ2THMIN;  
  std::cout << DUMMYSTR << SQ2THMIN  << std::endl; 
  fileDataCard >> DUMMYSTR >> SQ2THMAX;  
  std::cout << DUMMYSTR << SQ2THMAX  << std::endl; 


  //init AIDA for Histo/Tuple
  AIDA::IAnalysisFactory* aida = AIDA_createAnalysisFactory();
  if(!aida) {
    std::cerr  << " AIDA not found." << std::endl;
    return 0;
  }

  //ROOT tree :
  AIDA::ITreeFactory* treeFactory = aida->createTreeFactory();
  std::string opts = "export=root";
  AIDA::ITree* fTree = 
    treeFactory->create(ROOTFILENAME,"root",false,true,opts);
  delete treeFactory;

 //Booking Tuple
  AIDA::ITupleFactory* tf = aida->createTupleFactory(*fTree);

  int NumberOfColumn = 7;
  std::vector<std::string> column(NumberOfColumn);
  const char* c_column[] = {"theta12", "theta13", "theta23", 
			    "deltaCP", "dm21", "dm31", 
			    "chi2"};
  std::vector<std::string> coltype(NumberOfColumn);
  const char* c_coltype[] = {"double","double","double",
			     "double","double","double",
			     "double"};
  for (int icol = 0; icol<NumberOfColumn; ++icol) {
    column[icol]  = c_column[icol];
    coltype[icol] = c_coltype[icol];
  }

  AIDA::ITuple* myTuple = 
    tf->create("SplGlb","dm31 - theta23",column,coltype);
  
 
  //Init Globes
  glbInit(argv[0]);
  glbInitExperiment("../data/SPL.glb", 
		    &glb_experiment_list[0], 
		    &glb_num_of_exps);

  // input errors
  glb_params input_errors = glbAllocParams();
  glbDefineParams(input_errors, 
		  TH12*0.05, 0., 0., 0., 
		  DMQ21*0.05, 0.);
  glbSetDensityParams(input_errors, 0.05, GLB_ALL);
  glbSetInputErrors(input_errors);



  glb_params true_values = glbAllocParams();
  glb_params start_values = glbAllocParams();
  glb_params test_values = glbAllocParams();

  //Projection. Theta23-Dm31
  glb_projection proj = glbAllocProjection();
  glbDefineProjection(proj, GLB_FREE, GLB_FREE, GLB_FIXED,
		            GLB_FREE, GLB_FREE, GLB_FIXED);
  glbSetProjection(proj);

  std::cout << "Start to loop...." << std::endl;


  double res;
  double fit_theta12, fit_theta13,fit_theta23,fit_deltaCP,fit_dmSol,fit_dmAtm;
  double log10s2, sq2th, th;
  double log10dm, dm;

  //Define the True Values (the default experiment)
  glbDefineParams(true_values, TH12, TH13, TH23, DELTA, DMQ21, DMQ31);
  glbSetOscillationParameters(true_values);  
  glbSetRates();
  // set Starting Values
  glbDefineParams(start_values, TH12, TH13, TH23, DELTA, DMQ21, DMQ31);
  glbSetStartingValues(start_values);


  for(int j = 0; j < NDM; j++)
  {
    //scan de DM31
    dm = DMMIN + (DMMAX -  DMMIN) * double(j) / (NDM-1);


    for(int k = 0; k < NTH; k++)
    {      
      //scan de THETA23
      sq2th = SQ2THMIN + (SQ2THMAX-SQ2THMIN) * double(k) / (NTH-1);
      th = asin(sqrt(sq2th));
      
      std::cout << "dm31 j:" << j << " theta13 k:" << k << std::endl;
      
      // init test values
      glbDefineParams(test_values, TH12, TH13, th, DELTA, DMQ21, dm);
      //Chi2
      if ( (dm>2.2e-3) && (dm<2.6e-3) && (sq2th>0.35) && (sq2th<0.65) ) {
	res = glbChiNP(test_values,NULL,GLB_ALL);
      }	else {
	res = glbChiSys(test_values,GLB_ALL,GLB_ALL);
      }
      //store the true_values theta13,dm31, the other variables are there
      //just for compatibility for the Tuple definition
      fit_theta12 = glbGetOscParams(test_values, GLB_THETA_12);
      fit_theta13 = glbGetOscParams(test_values, GLB_THETA_13);
      fit_theta23 = glbGetOscParams(test_values, GLB_THETA_23);
      fit_deltaCP = glbGetOscParams(test_values, GLB_DELTA_CP);
      fit_dmSol   = glbGetOscParams(test_values, GLB_DM_SOL);
      fit_dmAtm   = glbGetOscParams(test_values, GLB_DM_ATM);


//       std::cout << "Theta_12(rad) " <<  fit_theta12 << " "
//  		<< "Theta_13(rad) " <<  fit_theta13 << " "
// 		<< "Theta_23(deg) " <<  fit_theta23*180./M_PI << " "
// 		<< "Delta_CP(deg) " <<  fit_deltaCP*180./M_PI << " "
// 		<< "DM_21    " <<  fit_dmSol   << " "
// 		<< "DM_31    " <<  fit_dmAtm   << " "
// 		<< "Chi2 (fin) " << res
// 		<< std::endl;       


      //Store in the Tuple
      myTuple->fill(0,fit_theta12);
      myTuple->fill(1,fit_theta13);
      myTuple->fill(2,fit_theta23);
      myTuple->fill(3,fit_deltaCP);
      myTuple->fill(4,fit_dmSol);
      myTuple->fill(5,fit_dmAtm);
      myTuple->fill(6,res);
      myTuple->addRow();

      

    }//Loop on Theta13
  }//Loop on Dm31
  
  //free GLoBES arrays
  glbFreeParams(true_values);
  glbFreeParams(test_values);
  glbFreeParams(start_values);

  //save Tuple
  fTree->commit();
  delete fTree;
  
  delete aida;
  return 0;
}
    




