//std
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <cmath>
#include <fstream>
#include <iostream>

//Globes
#include <globes/globes.h>

// AIDA :
#include <AIDA/IAnalysisFactory.h>
#include <AIDA/ITreeFactory.h>
#include <AIDA/IHistogramFactory.h>
#include <AIDA/ITree.h>
#include <AIDA/ITupleFactory.h>
#include <AIDA/ITuple.h>



// #define TH12 ( asin(sqrt(0.3)) )
// #define TH23 ( asin(sqrt(0.6)) )
// #define TH13 ( 0.5 * asin(sqrt(0.03)) )
// #define DELTA (-0.85 * M_PI )
// #define DMQ21 8.1e-5
// #define DMQ31 2.2e-3
// #define ND  31  
// #define NTH 41
// #define SQ2THMAX 0.08


int WRONG_TH23, WRONG_HIER; //condition on octant/hierarchy
float TH12,TH13,TH23,DELTA,DMQ21,DMQ31; //theta12,theta13,theta23,deltaCP,Dm^2_21,Dm^2_31

int ND; //number of bins to scan delta parameter
float DELTAMIN, DELTAMAX; //minimum and maximum values of delta to scan (fraction de Pi radian)
int NTH13; //number of bins to scan theta13 parameter
float S22TH13MIN, S22TH13MAX; //minimum and maximum values of sin^2(2theta13) to scan


bool test_th23(glb_params fit_values) {
  double fit_th23 = glbGetOscParams(fit_values, GLB_THETA_23);
  
  // testing if fit_th23 is at the same side as the true value
  
  if (fabs(TH23 - M_PI/4) < 1e-6) return true;
  
  return  ( 
	   (WRONG_TH23 == 0 && 
	    (TH23 > M_PI/4. && fit_th23 > M_PI/4.) ||
	    (TH23 < M_PI/4. && fit_th23 < M_PI/4.))
	   ||
	   (WRONG_TH23 == 1 && 
	    (TH23 > M_PI/4. && fit_th23 < M_PI/4.) ||
	    (TH23 < M_PI/4. && fit_th23 > M_PI/4.))
	   );
}//same_th23

//---------------------------------------------------------------------
bool test_hier(glb_params fit_values) {
  double fit_dmq = glbGetOscParams(fit_values, GLB_DM_ATM);
  
  // testing if fit_dmq has the same sign as the true value
  return ( 
	  (WRONG_HIER == 0 && fit_dmq * DMQ31 > 0) || 
	  (WRONG_HIER == 1 && fit_dmq * DMQ31 < 0) 
	  );
}//same_hier

//---------------------------------------------------------------------

bool test(glb_params fit_values) {    
  return test_th23(fit_values) && test_hier(fit_values);
}


/**************************************/
/*           main                     */
/**************************************/

int main(int argc, char *argv[])
{
//   if(argc != 3){
//     std::cerr << "usage:" << argv[0] << "WRONG_TH23 WRONG_HIER" << std::endl;
//     std::cerr<< "WRONG_* = '1' for wrong * and '0' for right *" << std::endl;
//     return 0;
//   }
  
//   if(sscanf(argv[1], "%d", &WRONG_TH23) != 1 ||
//      (WRONG_TH23 != 1 && WRONG_TH23 != 0) ||
//      sscanf(argv[2], "%d", &WRONG_HIER) != 1 ||
//      (WRONG_HIER != 1 && WRONG_HIER != 0)){
//     std::cerr<< "cannot read parameters" << std::endl;
//     return 0;
//   }
 
  //Process data card file
  std::string ROOTDIR = getenv("GLBFREJUSROOT");
  std::string DATACARD;
  DATACARD = ROOTDIR + "/run/measTh13Delta.data"; 
  std::ifstream fileDataCard;
  std::cout << "Open DataCard file : " << DATACARD <<std::endl;
  fileDataCard.open(DATACARD.data());
  std::string DUMMYSTR; //comment string of the variables

  std::string ROOTFILENAME;


  fileDataCard >> DUMMYSTR >> WRONG_TH23; 
  std::cout << DUMMYSTR << " " << WRONG_TH23 << std::endl; 
  fileDataCard >> DUMMYSTR >> WRONG_HIER;
  std::cout << DUMMYSTR << " " << WRONG_HIER << std::endl; 
  fileDataCard >> DUMMYSTR >> TH12;  
  std::cout << DUMMYSTR << " " << TH12 << std::endl; 
  fileDataCard >> DUMMYSTR >> TH13;  
  std::cout << DUMMYSTR << " " << TH13 << std::endl; 
  fileDataCard >> DUMMYSTR >> TH23;  
  std::cout << DUMMYSTR << " " << TH23 << std::endl; 
  fileDataCard >> DUMMYSTR >> DELTA;  
  std::cout << DUMMYSTR << " " << DELTA << std::endl; 
  fileDataCard >> DUMMYSTR >> DMQ21;  
  std::cout << DUMMYSTR << " " << DMQ21 << std::endl; 
  fileDataCard >> DUMMYSTR >> DMQ31;  
  std::cout << DUMMYSTR << " " << DMQ31 << std::endl; 
  fileDataCard >> DUMMYSTR >> ROOTFILENAME;  

  //add to ROOT file name the conditions on the Octant/Hierarchy
  ROOTFILENAME += "-h";
  char hier[40];
  sprintf(hier,"%d",WRONG_HIER);
  ROOTFILENAME += hier;
  char octo[40];
  sprintf(octo,"%d",WRONG_TH23);
  ROOTFILENAME += "-o";
  ROOTFILENAME += octo;
  ROOTFILENAME += ".root";
  std::cout << DUMMYSTR << " " <<ROOTFILENAME  << std::endl; 

  fileDataCard >> DUMMYSTR >> ND;  
  std::cout << DUMMYSTR << " " << ND  << std::endl; 
  fileDataCard >> DUMMYSTR >> NTH13;  
  std::cout << DUMMYSTR << " " << NTH13  << std::endl; 
  fileDataCard >> DUMMYSTR >> DELTAMIN;  
  std::cout << DUMMYSTR << " " << DELTAMIN << std::endl; 
  fileDataCard >> DUMMYSTR >> DELTAMAX;  
  std::cout << DUMMYSTR << " " << DELTAMAX << std::endl; 
  fileDataCard >> DUMMYSTR >> S22TH13MIN;  
  std::cout << DUMMYSTR << " " << S22TH13MIN << std::endl; 
  fileDataCard >> DUMMYSTR >> S22TH13MAX;  
  std::cout << DUMMYSTR << " " << S22TH13MAX << std::endl; 

  //init AIDA for Histo/Tuple
  AIDA::IAnalysisFactory* aida = AIDA_createAnalysisFactory();
  if(!aida) {
    std::cerr  << " AIDA not found." << std::endl;
    return 0;
  }

  //ROOT tree :
  AIDA::ITreeFactory* treeFactory = aida->createTreeFactory();
  std::string opts = "export=root";
  AIDA::ITree* fTree = 
    treeFactory->create(ROOTFILENAME,"root",false,true,opts);
  delete treeFactory;

 //Booking Tuple
  AIDA::ITupleFactory* tf = aida->createTupleFactory(*fTree);

  int NumberOfColumn = 7;
  std::vector<std::string> column(NumberOfColumn);
  const char* c_column[] = {"theta12", "theta13", "theta23", 
			    "deltaCP", "dm21", "dm31", 
			    "chi2"};
  std::vector<std::string> coltype(NumberOfColumn);
  const char* c_coltype[] = {"double","double","double",
			     "double","double","double",
			     "double"};
  for (int icol = 0; icol<NumberOfColumn; ++icol) {
    column[icol]  = c_column[icol];
    coltype[icol] = c_coltype[icol];
  }

  AIDA::ITuple* myTuple = 
    tf->create("SplGlb","Measure SPL Hier=T, Oct=T",column,coltype);
  
 
  //Init Globes
  glbInit(argv[0]);
  glbInitExperiment("../data/SPL.glb", 
		    &glb_experiment_list[0], 
		    &glb_num_of_exps);

  // true values (reference for future Chi2 computations) 
  glb_params true_values = glbAllocParams();
  glbDefineParams(true_values, TH12, TH13, TH23, DELTA, DMQ21, DMQ31);
  std::cout << "The Initial True_values" << std::endl;
  glbPrintParams(stdout,true_values);
  
  glbSetOscillationParameters(true_values);  
  glbSetRates();
  
  // set Starting Values
  glb_params start_values = glbAllocParams();
  glbDefineParams(start_values, TH12, TH13, TH23, DELTA, DMQ21, DMQ31);
    
  if(WRONG_HIER == 1)
    glbSetOscParams(start_values, -DMQ31+DMQ21, GLB_DM_ATM);

  if(WRONG_TH23 == 1)
    glbSetOscParams(start_values, 0.5*M_PI - TH23, GLB_THETA_23);

  glbSetStartingValues(start_values);
  std::cout << "The Starting values 1st trail" << std::endl;
  glbPrintParams(stdout,start_values);
  glbFreeParams(start_values);

  
  // init test values
  glb_params test_values = glbAllocParams();
  glbDefineParams(test_values, TH12, TH13, TH23, DELTA, DMQ21, DMQ31);
  
  if(WRONG_HIER == 1)
    glbSetOscParams(test_values, -DMQ31+DMQ21, GLB_DM_ATM);
  
  if(WRONG_TH23 == 1)
    glbSetOscParams(test_values, 0.5*M_PI - TH23, GLB_THETA_23);
  std::cout << "The Test_values" << std::endl;
  glbPrintParams(stdout,test_values);

  glb_params fit_values = glbAllocParams(); //final minimization

  // Set theta23 error very low to constraint the minimizer in the right octant
  // input errors
  glb_params input_errors = glbAllocParams();
  glbDefineParams(input_errors, 
		  TH12*0.05, 0., TH23*0.30, 0., 
		  DMQ21*0.05, fabs(DMQ31)*0.30);
  glbSetDensityParams(input_errors, 0.05, GLB_ALL);
  glbSetInputErrors(input_errors);


  std::cout << "Start to loop...." << std::endl;

  double res;
  double fit_theta12, fit_theta13,fit_theta23,fit_deltaCP,fit_dmSol,fit_dmAtm;
  double delta, sq2th, th;

  for(int j = 0; j < ND; j++) {
    delta = DELTAMIN + (DELTAMAX-DELTAMIN)  * double(j) / (ND-1);
    delta *= M_PI; //rescale in radian

    glbSetOscParams(test_values, delta, GLB_DELTA_CP);

    for(int k = 0; k < NTH13; k++) {      
      sq2th = S22TH13MIN + (S22TH13MAX - S22TH13MIN) * double(k) / (NTH13-1);
      th = 0.5 * asin(sqrt(sq2th));
      
      std::cout << "delta j:" << j << " theta13 k:" << k << std::endl;
      
      glbSetOscParams(test_values, th, GLB_THETA_13);
      

      //Find minimum in the projection Theta13 Delta_CP
      res = glbChiThetaDelta(test_values,fit_values,0);
      
      //Check if the Parameter Vector respect degeneracy Octant/Hierarchy
      fit_theta12 = glbGetOscParams(fit_values, GLB_THETA_12);
      fit_theta13 = glbGetOscParams(fit_values, GLB_THETA_13);
      fit_theta23 = glbGetOscParams(fit_values, GLB_THETA_23);
      fit_deltaCP = glbGetOscParams(fit_values, GLB_DELTA_CP);
      fit_dmSol   = glbGetOscParams(fit_values, GLB_DM_SOL);
      fit_dmAtm   = glbGetOscParams(fit_values, GLB_DM_ATM);

      if (!test(fit_values)) res += 1e6;


      
//       std::cout << "Theta_12 " <<  fit_theta12 << " "
//  		<< "Theta_13 " <<  fit_theta13 << " "
// 		<< "Theta_23 " <<  fit_theta23*180./M_PI << " "
// 		<< "Delta_CP " <<  fit_deltaCP << " "
// 		<< "DM_21    " <<  fit_dmSol   << " "
// 		<< "DM_31    " <<  fit_dmAtm   << " "
// 		<< "Chi2 (mini) " << res
// 		<< std::endl;       


      myTuple->fill(0,fit_theta12);
      myTuple->fill(1,fit_theta13);
      myTuple->fill(2,fit_theta23);
      myTuple->fill(3,fit_deltaCP);
      myTuple->fill(4,fit_dmSol);
      myTuple->fill(5,fit_dmAtm);
      myTuple->fill(6,res);
      myTuple->addRow();

      

    }//Loop on Theta13
  }//Loop on DeltaCP
  
  glbFreeParams(true_values);
  glbFreeParams(test_values);
  glbFreeParams(fit_values);


  //save Tuple
  fTree->commit();
  delete fTree;
  
  delete aida;
  return 0;
}
    




