//std
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <cmath>
#include <fstream>
#include <iostream>

//Globes
#include <globes/globes.h>

// AIDA :
#include <AIDA/IAnalysisFactory.h>
#include <AIDA/ITreeFactory.h>
#include <AIDA/IHistogramFactory.h>
#include <AIDA/ITree.h>
#include <AIDA/ITupleFactory.h>
#include <AIDA/ITuple.h>


/*
  Sensibility to delta and theta_13
  Theta_13=0 and Delta=0 for the true value of the reference experiment
  use glbChiDeltaTheta to marginalized other all parameters except of 
  the current delta and theta
 */
//FIXME: transfert the #defined variables to Data Cards
#define TH12 ( 0.5 * asin(sqrt(0.82)) )
#define TH23 ( M_PI/4.0 )

#define TH13   0.0  
#define DELTA  0.0

#define DMQ21 8.2e-5
#define DMQ31 2.5e-3


int WRONG_TH23, WRONG_HIER;


/**************************************/
/*           main                     */
/**************************************/

int main(int argc, char *argv[])
{
  //init AIDA for Histo/Tuple
  AIDA::IAnalysisFactory* aida = AIDA_createAnalysisFactory();
  if(!aida) {
    std::cerr  << " AIDA not found." << std::endl;
    return 0;
  }

  //ROOT tree :
  AIDA::ITreeFactory* treeFactory = aida->createTreeFactory();
  std::string opts = "export=root";
  AIDA::ITree* fTree = 
    treeFactory->create("SPLDeltaTheta2+8OldFluxCorr.root","root",false,true,opts);
  delete treeFactory;

 //Booking Tuple
  AIDA::ITupleFactory* tf = aida->createTupleFactory(*fTree);

  int NumberOfColumn = 7;
  std::vector<std::string> column(NumberOfColumn);
  const char* c_column[] = {"theta12", "theta13", "theta23", 
			    "deltaCP", "dm21", "dm31", 
			    "chi2"};
  std::vector<std::string> coltype(NumberOfColumn);
  const char* c_coltype[] = {"double","double","double",
			     "double","double","double",
			     "double"};
  for (int icol = 0; icol<NumberOfColumn; ++icol) {
    column[icol]  = c_column[icol];
    coltype[icol] = c_coltype[icol];
  }

  AIDA::ITuple* myTuple = 
    tf->create("SplGlb","Delta-Theta sensibility",column,coltype);
  
  //Init Globes
  glbInit(argv[0]);
  glbInitExperiment("../data/SPL.glb", 
		    &glb_experiment_list[0], 
		    &glb_num_of_exps);

  // true values (reference for future Chi2 computations) 
  glb_params true_values = glbAllocParams();
  glbDefineParams(true_values, TH12, TH13, TH23, DELTA, DMQ21, DMQ31);
  glbPrintParams(stdout,true_values);
  
  glbSetOscillationParameters(true_values);  
  glbSetRates();
  
  // set Starting Values
  glb_params start_values = glbAllocParams();
  glbDefineParams(start_values, TH12, TH13, TH23, DELTA, DMQ21, DMQ31);
  glbSetStartingValues(start_values);
  glbPrintParams(stdout,start_values);
  glbFreeParams(start_values);
  
  // init test values
  glb_params test_values = glbAllocParams();
  glbDefineParams(test_values, TH12, TH13, TH23, DELTA, DMQ21, DMQ31);
  glbPrintParams(stdout,test_values);


  // input errors
  // 5% on Solar parameters, the atmospheric parameters are 
  // better determined by disappearence channels here 30% to drive the
  // minimizer
  glb_params input_errors = glbAllocParams();
  glbDefineParams(input_errors, 
		  TH12*0.05, 0., TH23*0.30, 0., 
		  DMQ21*0.05, fabs(DMQ31)*0.30);
  glbSetDensityParams(input_errors, 0.05, GLB_ALL);
  glbSetInputErrors(input_errors);


  glb_params fit_values = glbAllocParams(); //final minimization


#define ND  31  
#define NTH 41
#define LOG10MIN -4.0
#define LOG10MAX -1.0

  std::cout << "Start to loop...." << std::endl;

  double res;
  double fit_theta12, fit_theta13,fit_theta23,fit_deltaCP,fit_dmSol,fit_dmAtm;
  double delta, log10s2, sq2th, th;

  for(int j = 0; j < ND; j++)
  {
    //scan de -Pi a +Pi pour delta_CP
    delta = -M_PI + 2.0 * M_PI * double(j) / (ND-1);
    
    glbSetOscParams(test_values, delta, GLB_DELTA_CP);

    for(int k = 0; k < NTH; k++)
    {      
      log10s2 = LOG10MIN + (LOG10MAX-LOG10MIN) * double(k) / (NTH-1);
      sq2th = pow(10.,log10s2);
      th = 0.5 * asin(sqrt(sq2th));
      glbSetOscParams(test_values, th, GLB_THETA_13);
      
      //Param correlation
      res = glbChiThetaDelta(test_values,fit_values,0);

      std::cout << "delta j:" << j << " theta13 k:" << k
		<< " chi2 : " << res
		<< std::endl;

      fit_theta12 = glbGetOscParams(fit_values, GLB_THETA_12);
      fit_theta13 = glbGetOscParams(fit_values, GLB_THETA_13);
      fit_theta23 = glbGetOscParams(fit_values, GLB_THETA_23);
      fit_deltaCP = glbGetOscParams(fit_values, GLB_DELTA_CP);
      fit_dmSol   = glbGetOscParams(fit_values, GLB_DM_SOL);
      fit_dmAtm   = glbGetOscParams(fit_values, GLB_DM_ATM);
      
      myTuple->fill(0,fit_theta12);
      myTuple->fill(1,fit_theta13);
      myTuple->fill(2,fit_theta23);
      myTuple->fill(3,fit_deltaCP);
      myTuple->fill(4,fit_dmSol);
      myTuple->fill(5,fit_dmAtm);
      myTuple->fill(6,res);
      myTuple->addRow();
      
      //       std::cout << "Theta_12(rad) " <<  fit_theta12 << " "
      //  		<< "Theta_13(rad) " <<  fit_theta13 << " "
      // 		<< "Theta_23(deg) " <<  fit_theta23*180./M_PI << " "
      // 		<< "Delta_CP(deg) " <<  fit_deltaCP*180./M_PI << " "
      // 		<< "DM_21    " <<  fit_dmSol   << " "
      // 		<< "DM_31    " <<  fit_dmAtm   << " "
      // 		<< "Chi2 (fin) " << res
      // 		<< std::endl;       
      
    }//Loop on Theta13
  }//Loop on DeltaCP
  
  glbFreeParams(true_values);
  glbFreeParams(test_values);
  glbFreeParams(fit_values);


  //save Tuple
  fTree->commit();
  delete fTree;
  
  delete aida;
  return 0;
}
    




