#ifndef MEMPHYSEventAction_h
#define MEMPHYSEventAction_h 1

//Geant4
#include "G4UserEventAction.hh"
#include "G4ThreeVector.hh"
#include "G4Types.hh"
#include "G4ios.hh"

//MEMPHYS
#include "MEMPHYS/MEMPHYSDetectorConstruction.hh"
#include "MEMPHYS/MEMPHYSWCHit.hh"
#include "MEMPHYS/MEMPHYSWCDigi.hh"


class G4Event;

//JEC 10/11/05 introduce AIDA
namespace AIDA {
  class ITuple;
}


class MEMPHYSAnalysis; 
class MEMPHYSRunAction;
class MEMPHYSPrimaryGeneratorAction;

class MEMPHYSEventAction : public G4UserEventAction {
  
 public:
  MEMPHYSEventAction(MEMPHYSAnalysis&,
		     MEMPHYSRunAction*, 
		     MEMPHYSDetectorConstruction*,
		     MEMPHYSPrimaryGeneratorAction*);
  virtual ~MEMPHYSEventAction();
  
 public:
  void BeginOfEventAction(const G4Event*);
  void EndOfEventAction(const G4Event*);
  
  MEMPHYSRunAction* GetRunAction(){return runAction;}
  
 private:
  G4int MEMPHYSEventFindStartingVolume(G4ThreeVector vtx);
  G4int MEMPHYSEventFindStoppingVolume(G4String stopVolumeName);
  
 private:
  //JEC FIXME is it necessary to maintain fAnalysis?
  MEMPHYSAnalysis&               fAnalysis;            //the Analysis
  MEMPHYSRunAction*              runAction;            //the Run
  MEMPHYSPrimaryGeneratorAction* generatorAction;      //the Generator 
  MEMPHYSDetectorConstruction*   detectorConstructor;  //the Detector

  AIDA::ITuple*                  eventTuple;           //the Event tuple

};


#endif

    
