#ifndef MEMPHYSWCDigi_h
#define MEMPHYSWCDigi_h 1

#include "G4VDigi.hh"
#include "G4TDigiCollection.hh"
#include "G4Allocator.hh"
#include "G4ThreeVector.hh"

class MEMPHYSWCDigi : public G4VDigi {

public:
  
  MEMPHYSWCDigi();
  virtual ~MEMPHYSWCDigi();
  MEMPHYSWCDigi(const MEMPHYSWCDigi&);
  const MEMPHYSWCDigi& operator=(const MEMPHYSWCDigi&);
  int operator==(const MEMPHYSWCDigi&) const;
  
  inline void* operator new(size_t);
  inline void  operator delete(void*);
  
  void Draw(); //JEC FIXME what do we do with this?
  void Print();

private:
  
  G4int   tubeID;
  G4float pe;   
  G4float time; 
  
public:
  
  inline void SetTubeID(G4int tube) {tubeID = tube;};
  inline void SetPe(G4float Q)      {pe     = Q;};
  inline void SetTime(G4float T)    {time   = T;};
  
  inline G4int   GetTubeID() {return tubeID;};
  inline G4float GetPe()     {return pe;};
  inline G4float GetTime()   {return time;};
  
};

//-----------------------------------------------------------------------

typedef G4TDigiCollection<MEMPHYSWCDigi> MEMPHYSWCDigitsCollection;
extern G4Allocator<MEMPHYSWCDigi> MEMPHYSWCDigiAllocator;

inline void* MEMPHYSWCDigi::operator new(size_t) {
  void* aDigi;
  aDigi = (void*) MEMPHYSWCDigiAllocator.MallocSingle();
  return aDigi;
}

inline void MEMPHYSWCDigi::operator delete(void* aDigi) {
  MEMPHYSWCDigiAllocator.FreeSingle((MEMPHYSWCDigi*) aDigi);
}

#endif









