#ifndef MEMPHYSWCHit_h
#define MEMPHYSWCHit_h 1

//Geant4
#include "G4VHit.hh"
#include "G4THitsCollection.hh"
#include "G4Allocator.hh"
#include "G4ThreeVector.hh"
#include "G4LogicalVolume.hh"
#include "G4ios.hh"

//std
#include <algorithm> // for sort, find, count_if
#include <functional> //for less_equal, bind2nd,...

class MEMPHYSWCHit : public G4VHit {
 public:
  
  MEMPHYSWCHit();
  virtual ~MEMPHYSWCHit();
  G4int operator==(const MEMPHYSWCHit&) const;
  
  inline void* operator new(size_t);
  inline void  operator delete(void*);
  
  void Draw(); //JEC FIXME what do we do with this?
  void Print();
  
 public:
  
  void SetTubeID       (G4int tube)                 { tubeID = tube; };
  void SetTrackID      (G4int track)                { trackID = track; };
  void SetEdep         (G4double de)                { edep = de; };
  void SetPos          (G4ThreeVector xyz)          { pos = xyz; };
  void SetRot          (G4RotationMatrix rotMatrix) { rot = rotMatrix; };
  void SetLogicalVolume(G4LogicalVolume* logV)      { pLogV = logV;}

  // This is temporarily used for the drawing scale
  void SetMaxPe(G4int number = 0)  {maxPe   = number;};

  void AddPe(G4float hitTime);  

  G4int         GetTubeID()     { return tubeID; };
  G4int         GetTrackID()    { return trackID; };
  G4ThreeVector GetPos()        { return pos; };
  G4int         GetTotalPe()    { return totalPe;};
  G4float       GetTime(int i)  { return time[i];};
  
  void SortHitTimes() {   sort(time.begin(),time.end()); }
  G4int GetPeInGate(double pmtgate,double evgate);


 private:

  //JEC 17/11/05 put the Copy Ctor and the Assignation Operator private
  MEMPHYSWCHit(const MEMPHYSWCHit&);
  const MEMPHYSWCHit& operator=(const MEMPHYSWCHit&);
  
  G4int            tubeID;
  G4int            trackID;
  G4double         edep;
  G4ThreeVector    pos;
  G4RotationMatrix rot;
  G4LogicalVolume* pLogV;

  // This is temporarily used for the drawing scale
  // Since its static *every* WChit sees the same value for this.
  static G4int     maxPe;

  G4int                 totalPe;
  std::vector<G4float>  time;
  G4int                 totalPeInGate;
};

//----------------------------------------------------------------

typedef G4THitsCollection<MEMPHYSWCHit> MEMPHYSWCHitsCollection;

extern G4Allocator<MEMPHYSWCHit> MEMPHYSWCHitAllocator;

inline void* MEMPHYSWCHit::operator new(size_t) {
  void *aHit;
  aHit = (void *) MEMPHYSWCHitAllocator.MallocSingle();
  return aHit;
}

inline void MEMPHYSWCHit::operator delete(void *aHit) {
  MEMPHYSWCHitAllocator.FreeSingle((MEMPHYSWCHit*) aHit);
}

#endif
