
// Geant4:
#include "G4ios.hh"
#include "G4RunManager.hh"
#include "G4UImanager.hh"

//AIDA :
#include <AIDA/IAnalysisFactory.h>

// std::
#include <iostream>

// Lib :
#include <Lib/Interfaces/ISession.h>
#include <Lib/Manager.h>
#include <Lib/System.h>
//#include <Lib/Debug.h>

// G4Lab :
#include <G4Lab/UIOnX.h>
#include <G4Lab/TrackingAction.h>

//MEMPHYS:
#include "MEMPHYS/MEMPHYSAnalysis.hh"
#include "MEMPHYS/MEMPHYSDetectorConstruction.hh"
#include "MEMPHYS/MEMPHYSPhysicsList.hh"
#include "MEMPHYS/MEMPHYSPhysicsMessenger.hh"
#include "MEMPHYS/MEMPHYSPrimaryGeneratorAction.hh"
#include "MEMPHYS/MEMPHYSEventAction.hh"
#include "MEMPHYS/MEMPHYSRunAction.hh"
#include "MEMPHYS/MEMPHYSStackingAction.hh"
#include "MEMPHYS/MEMPHYSTrackingAction.hh"



// Create a manager to access the MEMPHYSAnalysis from the callbacks :

class MEMPHYSAnalysisManager 
  :public virtual IManager
  ,public MEMPHYSAnalysis  {
 public: //IManager
  virtual const std::string& name() const { return fName;}
  virtual void* cast(const std::string& aTo) const {
    if(aTo=="MEMPHYSAnalysisManager") {
      return (MEMPHYSAnalysisManager*)this;
    } else if(aTo=="MEMPHYSIAnalysis") {
      return (MEMPHYSIAnalysis*)this;
    } else if(aTo=="MEMPHYSAnalysis") {
      return (MEMPHYSAnalysis*)this;
    } else if(aTo=="IManager") {
      return (IManager*)this;
    } else {
      return 0;
    }
  }
 public:
  MEMPHYSAnalysisManager(AIDA::IAnalysisFactory& aAIDA,bool aBatch)
    :MEMPHYSAnalysis(aAIDA,aBatch),fName("MEMPHYSAnalysisManager") {}
  virtual ~MEMPHYSAnalysisManager(){}
 private:
  std::string fName;
};


//////////////////////////////////////////////////////////////////////////////
int main(
	 int aArgc
	 ,char** aArgv
	 ) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  //Lib::Debug::checkByClass(true);

  G4RunManager* runManager = new G4RunManager;

  // Need to pass the G4RunManager at UIOnX creation
  std::string gui = "$MEMPHYSROOT/scripts/OnX/MEMPHYS_session.onx";
  G4Lab::UIOnX* session = new G4Lab::UIOnX(runManager,gui,aArgc,aArgv);

  MEMPHYSAnalysisManager* analysisManager = 0;

  // Declare actions that needs some UI or analysis facilities :
  ISession* onxSession = session->session();
  if(onxSession) {
    // Get theg AIDA Lab implementation :
    AIDA::IAnalysisFactory* aida = 
      Lib_findManager(*onxSession,"AnalysisFactory",AIDA::IAnalysisFactory);
    if(!aida) {
      std::cout << "MEMPHYS_session :"
                << " AnalysisFactory not found." << std::endl;
    } else {
      analysisManager = new MEMPHYSAnalysisManager(*aida,false);
      onxSession->addManager(analysisManager);
    }
  }

  G4UImanager* UI = G4UImanager::GetUIpointer();
  if (UI) {
    std::string file = 
      Lib::System::getenv("MEMPHYSROOT")+"/scripts/Geant4/jobOptions.mac";
    UI->ApplyCommand("/control/execute "+file);  
  }

  
  //JEC 18/11/05 give the "analysis" to fill geometry ITuple
  MEMPHYSDetectorConstruction* MEMPHYSdetector = 
    new MEMPHYSDetectorConstruction(*analysisManager); 

  runManager->SetUserInitialization(MEMPHYSdetector);

  runManager->SetUserInitialization(new MEMPHYSPhysicsList);

  // Set user action classes
  MEMPHYSPrimaryGeneratorAction* myGeneratorAction = new MEMPHYSPrimaryGeneratorAction(MEMPHYSdetector);
  runManager->SetUserAction(myGeneratorAction);

  MEMPHYSRunAction* myRunAction = new MEMPHYSRunAction();

  runManager->SetUserAction(myRunAction);


  runManager->SetUserAction(new MEMPHYSEventAction(*analysisManager,
						   myRunAction, 
						   MEMPHYSdetector,
						   myGeneratorAction));
  runManager->SetUserAction(new MEMPHYSTrackingAction);

  runManager->SetUserAction(new MEMPHYSStackingAction);


  // Initialize G4 kernel
  runManager->Initialize();

  if (UI) {
    std::string file = 
      Lib::System::getenv("MEMPHYSROOT")+"/scripts/Geant4/init.g4m";
    UI->ApplyCommand("/control/execute "+file);  
  }

  // Main UI loop :
  session->SessionStart();

  delete session; //It will delete the analysisManager.

  delete runManager;

  return 0;
}

