// AIDA analysis program over MEMPHYS.root file.

// AIDA :
#include <AIDA/AIDA.h>
#include <AIDA/ITupleEntry.h>

// std :
#include <iostream>

//////////////////////////////////////////////////////////////////////////////
bool get_XYZ(
 AIDA::ITuple& aParent
,int aColumn
,double& aX
,double& aY
,double& aZ
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  AIDA::ITupleEntry* entry = (AIDA::ITupleEntry*)aParent.getObject(aColumn);
  if(!entry) return false;

  AIDA::ITuple* tuple = dynamic_cast<AIDA::ITuple*>(entry);
  if(!tuple) return false;

  tuple->start();
  if(!tuple->next()) return false;

  aX = tuple->getDouble(0);
  aY = tuple->getDouble(1);
  aZ = tuple->getDouble(2);

  return true;
}
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
bool process_pmtInfos(
 AIDA::ITuple& aParent
,FILE* aFile
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  AIDA::ITupleEntry* entry = (AIDA::ITupleEntry*)aParent.getObject(5);
  if(!entry) return false;

  AIDA::ITuple* tuple = dynamic_cast<AIDA::ITuple*>(entry);
  if(!tuple) return false;

  int irow = 0;

  tuple->start();
  while(tuple->next()) {

    //int pmtId = tuple->getInt(0);
    //int pmtLocation = tuple->getInt(1);

    double dx,dy,dz;
    if(!get_XYZ(*tuple,2,dx,dy,dz)) return false;

    double x,y,z;
    if(!get_XYZ(*tuple,3,x,y,z)) return false;

    std::cout << "----> PM{"<<irow<<"}: " 
              << " x,y,z " << x << " " << y << " " << z
              << " dx,dy,dz " << dx << " " << dy << " " << dz
              << std::endl;

    fprintf(aFile,"%g %g %g %g %g %g\n",x,y,z,dx,dy,dz);
    
    irow++;
    
  }
  return true;
}
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
int main(int aArgc,char** aArgv) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  std::string program = "MEMPHYS_geom";
  std::string header = program + " : ";

  AIDA::IAnalysisFactory* aida = AIDA_createAnalysisFactory();
  if(!aida) {
    std::cout << header << "AIDA not found." << std::endl;
    return 1;
  }

  AIDA::ITreeFactory* treeFactory = aida->createTreeFactory();
  if(!treeFactory) {
    std::cout << header << "can't get a TreeFactory." << std::endl;
    return 1;
  }

  ////////////////////////////////////////////////////////
  /// Read data //////////////////////////////////////////
  ////////////////////////////////////////////////////////

  std::string fmt = (aArgc>=2?aArgv[1]:"root"); //file extension

  AIDA::ITree* tree = treeFactory->create("MEMPHYS."+fmt,fmt,true,false);
  if(!tree) {
    std::cout << header << "can't open data file." << std::endl;
    return 1;
  }

  AIDA::IManagedObject* object = tree->find("Geometry");
  if(!object) {
    std::cout << header 
              << "object Geometry not found in tree." 
              << std::endl;
    return 1;
  }
  AIDA::ITuple* tuple = dynamic_cast<AIDA::ITuple*>(object);
  if(!tuple) {
    std::cout << header << "object not an AIDA::ITuple." << std::endl;
    return 1;
  }

  int coln = tuple->columns();
  for(int index=0;index<coln;index++) {
    std::cout << header 
              << " icol = " << index
              << ", label = " << tuple->columnName(index) 
              << ", type = " << tuple->columnType(index) 
              << std::endl;
  }

  std::cout << header << "rows = " << tuple->rows() << std::endl;

  int nentries = tuple->rows();
  //nentries = 100000;
  //nentries = 40;
  std::cout << header 
            << "traitements de " << nentries << " entrees" 
            << std::endl;

  FILE* file = fopen("MEMPHYS_geom.ascii","wb");

  int irow = 0;
  tuple->start();
  while(tuple->next() && (irow<nentries)) {

    if(!process_pmtInfos(*tuple,file)) return 1;

    irow++;
  }

  ::fclose(file);

  delete tree;
  delete treeFactory;

  delete aida;

  return 0;
}
