// this :
#include <MEMPHYS/HitsCollectionAccessor.h>

// Inventor :
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoDrawStyle.h>
#include <Inventor/nodes/SoCube.h>

// HEPVis :
#include <HEPVis/SbPolyhedron.h>
#include <HEPVis/misc/SoStyleCache.h>
//#include <HEPVis/misc/SoTools.h>
#include <HEPVis/nodes/SoHighlightMaterial.h>

#ifdef WIN32
#undef pascal // Clash between windef.h and Geant4/SystemOfUnits.hh
#endif

// Geant4 :
#include <G4LogicalVolume.hh>
#include <G4Colour.hh>

// Lib :
#include <Lib/smanip.h>

// G4Lab :
#include <G4Lab/Transform3D.h>

//////////////////////////////////////////////////////////////////////////////
MEMPHYS::HitsCollectionAccessor::HitsCollectionAccessor(
 Slash::Core::ISession& aSession
,G4RunManager* aRunManager
,const std::string& aHC
)
#ifdef OSC_VERSION_16_0
:G4Lab::HitsCollectionAccessor(aSession,aHC)
#else
:G4Lab::HitsCollectionAccessor(aSession,aRunManager,aHC)
#endif
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
MEMPHYS::HitsCollectionAccessor::~HitsCollectionAccessor(
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
void MEMPHYS::HitsCollectionAccessor::visualize(
 Slash::Data::IAccessor::Data aData
,void*
) 
//////////////////////////////////////////////////////////////////////////////
// The hit must have the "LV" and "TSF" AttDef.
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  G4VHit* obj = (G4VHit*)aData;  
  G4LogicalVolume* lv = hitLogicalVolume(*obj);
  if(!lv) return;
  G4Transform3D* tsf = hitTransform3D(*obj);
  if(!tsf) return;
  G4VSolid* solid = lv->GetSolid();
  if(!solid) return;
  //G4Material* material = lv->GetMaterial();

  SoSeparator* separator = new SoSeparator;
  separator->setName("sceneGraph");
      
 {SoStyleCache* styleCache = fSoGC.getStyleCache();
  G4Colour color;
  if(hitColor(*obj,color)) {
    SbColor sbColor((float)color.GetRed(),
                    (float)color.GetGreen(),
                    (float)color.GetBlue());
    float transp = 1.0F - (float)color.GetAlpha();

    //SbColor sbColor(1,0,0);
    //float transp = 0;

    separator->addChild(
      styleCache->getHighlightMaterial
        (sbColor,fSoGC.getHighlightColor(),transp));
  } else {
    separator->addChild(fSoGC.getHighlightMaterial());
  }
  separator->addChild(fSoGC.getDrawStyle());
  //separator->addChild(fSoGC.getLightModel());
  // Enforce base color (then suppress light effects) :
  separator->addChild(styleCache->getLightModelBaseColor());
  }

 {SoTransform* transform = new SoTransform;
  G4Lab::Transform3D* t = new G4Lab::Transform3D(*tsf);
  SbMatrix* matrix = t->getMatrix();
  transform->setMatrix(*matrix);
  delete matrix;
  delete t;
  separator->addChild(transform);}
          
  // Build name (for picking) :
  std::string s;
  Lib::smanip::printf(s,128,"%s/0x%lx",HCName().c_str(),(unsigned long)obj);
  SbName name(s.c_str());

  // Representation :

  //FIXME

  //FIXME : PM base size :
  //double WCPMTRadius           = 0.10*m;  // 20-cm PMTs (8-inch)
  //JEC 27/1/06 double WCPMTRadius           = 0.10*m;  // 20-cm PMTs (8-inch)
  float WCPMTRadius = 0.15F*m;  // PMTs (12-inch)

  // half size :
  float h = WCPMTRadius;

/*
  SbVec3f normal(0,0,1);
  SbVec3f line[5];
  line[0].setValue(+h,-h,0);
  line[1].setValue(+h,+h,0);
  line[2].setValue(-h,+h,0);
  line[3].setValue(-h,-h,0);
  line[4].setValue(+h,-h,0);
  SoTools::addPolygonToNode(separator,4,line,normal,"");
*/

  // Have a SoCube to hide the PM visualized at the
  // same place with "All PMs".
  SoCube* soCube = new SoCube;
  soCube->width.setValue(2*h);
  soCube->height.setValue(2*h);
  //Some tiny depth to include and hide the PM :
  soCube->depth.setValue(0.01F*h);
  separator->addChild(soCube);

  fSoRegion->doIt(SbAddNode(separator,"dynamicScene"));
}
