#ifndef G4Lab_DigitsCollectionAccessor_h
#define G4Lab_DigitsCollectionAccessor_h

// Inheritance :
#include <OnX/Inventor/InventorAccessor.h>

#include <G4Transform3D.hh>

class G4VDigiCollection;
class G4VDigi;
class G4LogicalVolume;
class G4Colour;
class G4RunManager;

namespace Slash {namespace Core {class ISession;}}
namespace Slash {namespace Core {class IWriter;}}

#include <map>
#include <G4AttDef.hh>
#include <G4String.hh>

namespace G4Lab {

class DigitsCollectionBaseAccessor : public OnX::InventorAccessor {
public: //Slash::Data::IAccessor
  virtual std::string name() const;
  virtual Slash::Core::IValue* findValue(Slash::Data::IAccessor::Data,const std::string&,void*);
public: //Slash::Data::IVisualizer
  virtual void beginVisualize();
  virtual void visualize(Slash::Data::IAccessor::Data,void*);
public:
  DigitsCollectionBaseAccessor(Slash::Core::ISession&,G4RunManager*,
                               const std::string& = "");
  virtual ~DigitsCollectionBaseAccessor();
  const std::string& DCName() const;
protected:
  static G4LogicalVolume* digiLogicalVolume(const G4VDigi&); 
  static G4Transform3D* digiTransform3D(const G4VDigi&); 
  static bool digiColor(const G4VDigi&,G4Colour&); 
  void setProperties(G4VDigi&); 
protected:
  G4VDigiCollection* getCollection(Slash::Core::IWriter&,const std::string&);
protected:
  std::string fType;
  G4RunManager* fRunManager;
  std::map<G4String,G4AttDef>* fAttDefs;
  std::string fDC;
};

}

#include <G4VDigi.hh>
#include <G4TDigiCollection.hh>
#include <Slash/Data/IIterator.h>

namespace G4Lab {

template <class T> 
class DigitsCollectionAccessor : public DigitsCollectionBaseAccessor {
public: //Slash::Data::IAccessor
  virtual Slash::Data::IIterator* iterator() {
    const std::vector<std::string>& args = iteratorArguments();
    if(args.size()) fDC = args[0];
    clearProperties();
    fAttDefs = 0;
    G4VDigiCollection* vdc = getCollection(printer(),fDC);
    if(!vdc) return 0;
    typedef G4TDigiCollection<T> Collection;
    Collection* dc = dynamic_cast<Collection*>(vdc);
    if(!dc) return 0;
    if(dc->entries()) {
      G4VDigi* digi = (*dc)[0];
      if(digi) setProperties(*digi);
    }
    class Iterator : public virtual Slash::Data::IIterator {
    public: //Slash::Data::IIterator
      virtual Slash::Data::IAccessor::Data object() {
        if(fCurrent>=fVector.entries()) return 0;
        G4VDigi* digi = fVector[fCurrent];
        return digi;
      }
      virtual void next() { fCurrent++;}
      virtual void* tag() { return 0;}
    public:
      Iterator(Collection& aVector):fVector(aVector),fCurrent(0) {}
      virtual ~Iterator() {}
    private:
      Collection& fVector;
      int fCurrent;
    };
    return new Iterator(*dc);
  }
public:
  DigitsCollectionAccessor(Slash::Core::ISession& aSession,G4RunManager* aRunManager,const std::string& aName = "")
  :DigitsCollectionBaseAccessor(aSession,aRunManager,aName){}
  virtual ~DigitsCollectionAccessor(){}
};


}

#endif
