/*
    LX200 Basic Driver
    Copyright (C) 2005 Jasem Mutlaq (mutlaqja@ikarustech.com)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

*/

#ifndef BAO_H
#define BAO_H

#include "indidevapi.h"
#include "indicom.h"
#include "ServerSocket.h"
#include "SocketException.h"
#include "astro.h"

#define MAXCARACTERES 1024

#define MAXATTENTE 40                //Si une commande ne recoit pas d'acknowledge. Alors refaire 40 tentatives en renvoyant la commande
#define MAXANOMALIES 2               //Si pas de réponse au bout de 80 tentatives -> erreur critique -> socket perdu ?

struct Position
{
    int x;
    int y;
};

struct DefSocket
{
    ServerSocket new_sock;
    
    std::string IP;              //IP de l'antenne
    
    bool Connected;              //le micro-contrôleur est-il connecté ?
    bool PosValides;             //le micro-contrôleur a-t-il donné une position valide ?
    char status;                 //status='B' pour busy  'R' pour READY
    int sendalertes;             //une requête "send" a généré une erreur sur le réseau
    int AttenteExecution;	 //L'antenne parvient-elle à executer un cycle de commandes ?
    int AnomaliesExecution;	 //Erreur critique. L'antenne ne répond plus !
                    
    Position Pos;                //dernière position retournée par le microcontrôleur    
    int etape;
    
    bool ack_status;             //Etat des acknowledges ?
    bool ack_pos;
    bool ack_park;
    bool ack_abort;
    bool ack_goto;
    bool GotoOk;                 //Est-ce que le dernier goto est OK ?
};

ServerSocket server( 8000 );
int SocketsNumber;
bool InitThreadOK;
DefSocket Sockets[MAXHOSTNAME + 1];
pthread_t th1;

class BAO : public Astro
{
public:
    BAO();
    ~BAO();
    
    void ISGetProperties (const char *dev);
    void ISNewNumber (const char *dev, const char *name, double values[], char *names[], int n);
    void ISNewText (const char *dev, const char *name, char *texts[], char *names[], int n);
    void ISNewSwitch (const char *dev, const char *name, ISState *states, char *names[], int n);
    void ISPoll ();
    void InitThread();
 
    bool COMMANDE(int numsocket, char* Commande, char* Params);
    Position ExtractPosition(std::string str);
  
    void connection_lost();
    void connection_resumed();
    
    bool STATUS(int numsocket);
    bool POSITION(int numsocket);
    bool ABORT(int numsocket);
    bool PARK(int numsocket);
    bool GOTO(int numsocket, int deltaAz, int deltaAlt);
    void ADDEC2Motor(double newRA, double newDEC);
    int  AntennesConnectees();
    void InitAntennes();
    
        
    
private:

    enum BAO_STATUS { BAO_TRANSIT, BAO_TRACKING, BAO_PARK };

    /* Switches */
    ISwitch ConnectS[2];
    ISwitch OnCoordSetS[2];
    ISwitch AbortSlewS[1];
    ISwitch ParkS[1];

    /* Texts */
    IText PortT[1];
    IText ObjectT[1];

    /* Numbers */
    //INumber EquatorialCoordsRN[2];
    INumber EquatorialCoordsWN[2];
    INumber GeographicCoordsWN[2];
    INumber ActualisationN1[1];
    INumber ActualisationN2[1];
    
    //INumber SlewAccuracyN[2];
    //INumber TrackAccuracyN[2];

    /* Switch Vectors */
    ISwitchVectorProperty ConnectSP;
    ISwitchVectorProperty OnCoordSetSP;
    ISwitchVectorProperty AbortSlewSP;
    ISwitchVectorProperty ParkSP;

    /* Number Vectors */
    //INumberVectorProperty EquatorialCoordsRNP;
    INumberVectorProperty EquatorialCoordsWNP;
    INumberVectorProperty GeographicCoordsWNP;
    //INumberVectorProperty SlewAccuracyNP;
    //INumberVectorProperty TrackAccuracyNP;
    INumberVectorProperty ActualisationNP1;
    INumberVectorProperty ActualisationNP2;
   

    /* Text Vectors */
    ITextVectorProperty PortTP;
    ITextVectorProperty ObjectTP;

    /*******************************************************/
    /* Connection Routines
    ********************************************************/
    void init_properties();
    void get_initial_data();
    void connect_telescope();
    bool is_connected(void);

    /*******************************************************/
    /* Misc routines
    ********************************************************/
    bool process_coords();
    int get_switch_index(ISwitchVectorProperty *sp);

    /*******************************************************/
    /* Simulation Routines
    ********************************************************/
    void enable_simulation(bool enable);

    /*******************************************************/
    /* Error handling routines
    ********************************************************/
    void slew_error(int slewCode);
    void reset_all_properties();
    void handle_error(INumberVectorProperty *nvp, int err, const char *msg);
    void correct_fault();

protected:

    double JD;				/* Julian Date */
    double lastRA;
    double lastDEC;
    double JJAnc;                       // Sauvegarde du jour julien de la dernière actualisation de la position (fct Goto)
    double ActualisationTM1;
    double ActualisationTM2;
    bool   simulation;
    bool   fault;
    bool   LecturePosition;             // étape dans le processus d'actualisation de la position
    bool   Abort;
    bool   Park;
    bool   Goto;
    bool   BAOConnected;
    
    int    fd;				/* Telescope tty file descriptor */
    int    currentSet;
    int    lastSet; 
    int    TrackingMode;                //1 : Transit           2: Tracking
     
    Position TargetPosition;            //Position à atteindre en coordonnées équatoriales 
};

#endif
