// Implementation of the ClientSocket class

#include "ClientSocket.h"
#include "SocketException.h"


#include <iostream>
#include <string>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>


ClientSocket::ClientSocket ( std::string host, int port )
{
  if ( ! Socket::create() )
    {
      throw SocketException ( "Could not create client socket." );
    }

  if ( ! Socket::connect ( host, port ) )
    {
      throw SocketException ( "Could not bind to port." );
    }
}


const ClientSocket& ClientSocket::operator << ( const std::string& s ) const
{
  if ( ! Socket::send ( s ) )
    {
     // throw SocketException ( "Could not write to socket." );
    }

  return *this;

}


const ClientSocket& ClientSocket::operator >> ( std::string& s ) const
{
  if ( ! Socket::recv ( s ) )
    {
    //   throw SocketException ( "Could not read from socket." );
    }

  return *this;
}


void ClientSocket::recv( std::string& s ) 
{
  if ( ! Socket::recv ( s ) )
    {
      sleep(1);

      if (! Socket::shutdown() ) std::cout << "shutdown impossible.\n";

      if (! Socket::create() ) std::cout << "create impossible.\n";

      if (! Socket::connect((std::string)"192.168.0.1", 8000)) { std::cout << "connect impossible.\n"; Socket::shutdown(); } else {   std::cout << "Reconnexion reussie.\n"; }
    }
}

