// Implementation of the ServerSocket class
// Franck RICHARD
// BAORadio

#include "ServerSocket.h"
#include "SocketException.h"
#include <net/if.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>


ServerSocket::ServerSocket ( int port )
{
    if ( ! Socket::create() )
    {
        throw SocketException ( "Could not create server socket." );
    }

    if ( ! Socket::bind ( port ) )
    {
        throw SocketException ( "Could not bind to port." );
    }

    if ( ! Socket::listen() )
    {
        throw SocketException ( "Could not listen to socket." );
    }

    Socket::set_non_blocking(true);
}

ServerSocket::~ServerSocket()
{
}


const ServerSocket& ServerSocket::operator << ( const std::string& s ) const
{
    if ( ! Socket::send ( s ) )
    {
        throw SocketException ( "Could not write to socket." );
    }

    return *this;

}


const ServerSocket& ServerSocket::operator >> ( std::string& s ) const
{
    if ( ! Socket::recv ( s ) )
    {
        throw SocketException ( "Could not read from socket." );
    }

    return *this;
}


void ServerSocket::accept ( ServerSocket& sock )
{
    if ( ! Socket::accept ( sock ) )
    {
        throw SocketException ( "Could not accept socket." );
    }
}

void ServerSocket::shutdown ( )
{
    if ( ! Socket::shutdown (  ) )
    {
        throw SocketException ( "Could not shutdown socket." );
    }
}

void ServerSocket::create ( )
{
    if ( ! Socket::create (  ) )
    {
        throw SocketException ( "Could not create socket." );
    }
}

bool ServerSocket::connect(std::string IP ) 
{
   return Socket::connect (IP, 8000);  
}

std::string ServerSocket::recupip( ServerSocket& sock)
{ 
   return ( Socket::recupip() ); 
}
