// Definition of the Astro BAOcontrol
// Franck RICHARD
// BAORadio

#ifndef BAOcontrol_class
#define BAOcontrol_class


#include <iostream>
#include <string.h>
#include <sstream>
#include "ClientSocket.h"
#include "SocketException.h"
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <X11/Xlib.h>
#include "filetools.h"
#include "../drivers/telescope/astro.h"
#include "math.h"
#include <time.h>
#include <unistd.h>
#include <sys/time.h>


// couleurs utilisées dans le terminal

#define red1 "\033[0;31m"
#define blue1 "\033[0;34m"
#define green1 "\033[0;32m"
#define black1 "\033[0;30m"
#define grey1 "\033[1;30m"
#define red2 "\033[1;31m"
#define blue2 "\033[1;34m"
#define green2 "\033[1;32m"
#define black2 "\033[1;30m"
#define grey2 "\033[1;37m"


// limites des tableaux

#define MAXLOG 1000
#define MAXOBJETS 100
#define MAXANTENNES 50


//dimensions de la fenêtre graphique

#define haut_fenetre 10+22*10
#define larg_fenetre 605

using namespace std;


struct DefAntenne
{
    unsigned char ip;			// Adresse ip d'une antenne

    char ok;				// actuellement disponible ?
};

// objets stockés dans le fichier de mouvements

struct DefObjets
{
    double JJ;				// Jour julien où le télescope doit aller pointer vers l'objet
    double Duree;			// Durée de l'observation de l'objet en sec
    string ad;				// Ascension droite J2000 de l'objet
    string de;				// déclinaison J2000 de l'objet
    bool exec;				// En cours d'exécution ?
};



class BAOcontrol : public Astro
{

public:
    BAOcontrol();
    ~BAOcontrol();

    void *my_thread_process ();
    int init(int argc, char **argv);


private:
    void Affiche(string chaine, bool AfficheEcran);
    void Affiche(stringstream *Message, bool AfficheEcran);
    void Erreur(string chaine);
    void Erreur(stringstream *Message);
    void initialiserFenetre();
    void Dessiner();
    void rouler();
    void LireReponse();
    bool VerifReponse(string reponseattendue);
    void Update();
    bool Decomposition(string chaine, char type, float *a1, float *a2, float *a3);
    bool DecompositionCommande(string chaine, string commande, string *chaine1, string *chaine2);
    bool EnvoyerCoordGeographiques();
    bool Park();
    bool Abort();
    bool Goto(string ar, string dec, bool Transit, bool J2000);
    bool Connect(bool connect);
    bool LectureFichierMouvements(string fileName);
    void DecodageEntreesUtilisateur(string chaine);
    bool Run(string fichier);
    bool ChargementParametres(string fileName);
    Coordonnees ServeurNED(string objet);
    int  readline (FILE * pfile, char *tab);



    // Variables globales

    XFontStruct * fd;                           // Police de caractères dans la fenêtre graphique

    char ChoixCouleurs;                         // 1-pour un terminal à fond blanc    2-pour un terminal à fond noir

    string logs[MAXLOG];                        // Sauvegarde de toutes les actions et réponses dans un tableau logs

    int delaitransit;				// Délai entre deux actualisations de la position en mode transit
    int delaitracking;				// Délai entre deux actualisations de la position en mode tracking
    int lognum;					// Nbre d'enregistrements dans le tableau logs
    int numAntenne;				// Nbre d'antennes connectées
    int numobjets;				// Nbre d'objets dans le dernier fichier de mouvements chargé
    int runnum;					// Numéro de l'objet actuellement visé dans le fichier de mouvement

    double Pression;				// Pression atmosphérique en mBar
    double Temperature; 			// température de l'atmosphère

    bool NoExit;				// A-t-on tapé exit pour sortir ? Permet de fermer le thread à ce moment-là
    bool Transit;				// Si oui, le mode transit est activé, sinon, c'est le mode tracking
    bool run;					// execute actuellement un fichier de mouvements
    bool exitrun;				// doit-on sortir du programme à la fin de l'execution de la commande run ?
    bool J2000;					// est-ce que les coordonnées du fichier de mouvements sont en coordonnées J2000 ?

    struct DefAntenne *Antennes;		// Sauvegarde de la situation actuelle de l'antenne i
    struct DefObjets  *objets;			// Liste des objets chargés depuis un fichier de mouvements

    string LatitudeChar;			// Latitude du lieu d'observation. Chargée depuis le fichier de configuration
    string LongitudeChar;			// Longitude du lieu d'observation. Chargée depuis le fichier de configuration
    string Serveur;				// Nom ou IP du serveur faisant tourner indi_BAO. Par defaut c'est localhost
    string Port; 				// Port utilisé pour connecter le serveur indi_BAO

    ClientSocket *client_socket;		// Socket permettant la connexion avec le pilote indi_BAO

    Display * d;				// contexte graphique
    Window w;					// fenêtre graphique
    Pixmap db;					// copie de la fenêtre pour permettre une actualisation sans scintillement
    GC noir, vert, rouge, gris;			// couleurs utilisées dans la fenêtre graphique

};

#endif
