#!/bin/sh
#
#Script sh d'extraction de fichiers d'irod 
# Auteur: JE Campagne (LAL Orsay)
# Creation: 2 mai 2011
# adaptation pour le CC 17 juin 2011
DATE=/bin/date
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
TR=/usr/bin/tr
MKDIR=/bin/mkdir
CAT=/bin/cat
RM=/bin/rm
LS=/bin/ls
DefaultIFS=$' \t\n'
IFS=$DefaultIFS

scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"



if [ ! $# = 4 ]; then
  $ECHO "usage: ${scriptName} <source:ex. Abell85> <date:YYYYMMDD> first last"
  touch ${tmppublicpath}/getsignalfiles.finished
  exit 0
fi

# Irods environment settings
#export PATH=$PATH:/home/bao/irods2.5_LinuxSL5
. /usr/local/shared/bin/irods_env.sh -noverbose

sourceRadio=$1
srclower=`${ECHO} ${sourceRadio} | ${TR} "[:upper:]" "[:lower:]" `
dateDAQ=$2

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"

#temporary files to synchronize scripts
tmppublicpath="/sps/baoradio/AmasNancay"
$LS -l ${tmppublicpath} > /dev/null


#Path where the job will do temporary IO
if [ ${ENVIRONMENT} == "INTERACTIVE" ]; then
    iojobpath="/sps/baoradio/AmasNancay/JEC"
    $MKDIR -p $iojobpath
elif [ ${ENVIRONMENT} == "BATCH" ] ; then
    iojobpath=${TMPBATCH}
else
   $ECHO "FATAL (${scriptName}): environment is ${ENVIRONMENT} not allowed"
   touch ${tmppublicpath}/getsignalfiles.finished
   exit 1
fi
cd ${iojobpath}

localpath="${sourceRadio}/${dateDAQ}${srclower}"
$MKDIR -p ./${localpath}
cd ./${localpath}

#Path of the utility scripts
scriptpath="/afs/in2p3.fr/home/c/campagne/private/work"


#determine the sequence of signal files to download
#get the daq current irod status
tag=`${DATE} +%F`
OUT1=${publicpath}/baodaqstatus-${tag}.txt

if [ ! -e ${OUT1} -o ! -r ${OUT1} ]; then
#     $ECHO "We should bring the DAQ status more up to date, this take few 
# sec..."
#     $RM -f ${tmppublicpath}/statusdaq.finished
#     ${scriptpath}/statusdaq.sh > ${OUT1}
#     while [ ! -f "${tmppublicpath}/statusdaq.finished" ]; do
# 	$ECHO "INFO (${scriptName}); waiting for ${tmppublicpath}/statusdaq.finished"
# 	date +%T
# 	sleep 30
#     done
#     $RM ${tmppublicpath}/statusdaq.finished
    $ECHO "FATAL (${scriptName}): ${OUT1} is missing or not readable..."
    touch ${tmppublicpath}/getsignalfiles.finished
    exit 1
fi

nfiles=`${GREP} "${sourceRadio}.*${dateDAQ}" ${OUT1} | ${AWK} '(NF==4){print $4}'` 
if [ "<${nfiles}>" == "<>" ]; then
    $ECHO "FATAL (${scriptName}): No run found for <${sourceRadio}> and date <${dateDAQ}>"
    $CAT $OUT1
    touch ${tmppublicpath}/getsignalfiles.finished
    exit 1
fi


firstFile=$3
if [ ${firstFile} -gt  ${nfiles} ]; then
    $ECHO "FATAL (${scriptName}): ${firstFile} >  ${nfiles}"
    touch ${tmppublicpath}/getsignalfiles.finished
    exit 1
fi


lastFile=$4
if [ ${lastFile} -gt  ${nfiles} ]; then
    $ECHO "FATAL (${scriptName}): ${lastFile} >  ${nfiles}"
    touch ${tmppublicpath}/getsignalfiles.finished
    exit 1
fi

if [ ${firstFile} -gt  ${lastFile} ]; then
    $ECHO "FATAL (${scriptName}): ${firstFile} >  ${lastFile}"
    touch ${tmppublicpath}/getsignalfiles.finished
    exit 1
fi


dirIrod="/baoradio/data/AmasNancay/${sourceRadio}/${dateDAQ}${srclower}"
dirLocal="."

##$ECHO "Ready to download [${firstFile},${lastFile}] in $dirLocal from $dirIrod"
#Nb we are in the localpath
$MKDIR -p Fiber1
$MKDIR -p Fiber2

OUT2=./igetStatus.$$

n=$firstFile
while [[ $n -le $lastFile ]]; do
   iget -r -f -v -K ${dirIrod}/Fiber1/signal$n.fits ${dirLocal}/Fiber1 >${OUT2} 2>&1
   igetStatus=`$GREP "^ERROR" ${OUT2}`
   if [ "<$igetStatus>" != "<>" ]; then
       $ECHO "FATAL (${scriptName}): error while iget:"
       $ECHO $igetStatus
       touch ${tmppublicpath}/getsignalfiles.finished
       exit 1
   fi
   iget -r -f -v -K ${dirIrod}/Fiber2/signal$n.fits ${dirLocal}/Fiber2 >${OUT2} 2>&1
   igetStatus=`$GREP "^ERROR" ${OUT2}`
   if [ "<$igetStatus>" != "<>" ]; then
       $ECHO "FATAL (${scriptName}): error while iget:"
       $ECHO $igetStatus
       touch ${tmppublicpath}/getsignalfiles.finished
       exit 1
   fi
   n=$(($n+1))
done

touch ${tmppublicpath}/getsignalfiles.finished
exit 0