#!/bin/sh
#download SCA file, proceed to introspection, and upload results
DATE=/bin/date
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
WC=/usr/bin/wc
CAT=/bin/cat
PRINTF=/usr/bin/printf
MKDIR=/bin/mkdir
XARGS=/usr/bin/xargs
SORT=/bin/sort
RM=/bin/rm
defaultIFS=$IFS

#set Irods environment    
. /usr/local/shared/bin/irods_env.sh -noverbose

scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"

#which source to analyse
sourceRadio=$1

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"


#Path where the job will do temporary IO
if [ ${ENVIRONMENT} = "INTERACTIVE" ]; then
    iojobpath="/sps/baoradio/AmasNancay/JEC"
    $MKDIR -p $iojobpath
elif [ ${ENVIRONMENT} = "BATCH" ] ; then
    iojobpath=${TMPBATCH}
else
    $ECHO "FATAL (${scriptName}): environment is ${ENVIRONMENT} not allowed"
    exit 1
fi
cd ${iojobpath}

localpath="${sourceRadio}"
$MKDIR -p ./${localpath}
cd ./${localpath}


#Path of the utility scripts
scriptpath="/afs/in2p3.fr/home/c/campagne/private/work"


#get the daq current irod status
tag=`${DATE} +%F`
OUT1=${publicpath}/baodaqstatus-${tag}.txt

if [ ! -e ${OUT1} ]; then
    $ECHO "We should bring the DAQ status more up to date, this take 1 or 2sec..."
    ${scriptpath}/statusdaq.sh > ${OUT1}
fi

if [ ! "<${sourceRadio}>" = "<>" ]; then
    $ECHO "You have selected sourceRadio = $sourceRadio"
    tableau=( `$GREP -i ${sourceRadio} ${OUT1} | $AWK '( NF==4 ) { print $2 }' ` )
else
    tableau=( `$CAT ${OUT1} | $AWK '( NF==4 ) { print $2 }'`  )
fi
IFS='
'
tableau=( $( $PRINTF "%s\n" "${tableau[@]}" | $AWK 'x[$0]++ == 0' ) )


workDir="headers"
$MKDIR -p ./${workDir}
cd ./${workDir}


nloop4dbg=0


for i in ${tableau[@]}
do
#look if the headers have been already extracted
  $ECHO "DEBUG (${scriptName}): irods root dir $i"
  for fibdir in Fiber1 Fiber2; do
      $ECHO "DEBUG (${scriptName}): Fiber $fibdir"
#NB: care should be taken to the fact that ILS returns all the instance of the file (HPSS, disk...)
#    so one should use a trick to count unique instance
      listOfsig=( `ils ${i}/${fibdir} | $GREP -i "signal" | $XARGS -i basename {} | $SORT -k1.7n` )
      IFS='
'
      listOfsig=( $( $PRINTF "%s\n" "${listOfsig[@]}" | $AWK 'x[$0]++ == 0' ) )
      nblinesSIG=${#listOfsig[@]}
      listOfhdr=( `ils ${i}/${fibdir} | $GREP -i "header" | $XARGS -i basename {} | $SORT -k1.7n` )
      IFS='
'
      listOfhdr=( $( $PRINTF "%s\n" "${listOfhdr[@]}" | $AWK 'x[$0]++ == 0' ) )
      nblinesHDR=${#listOfhdr[@]}
      $ECHO "(DEBUG) (${scriptName}:  test if $nblinesHDR != $nblinesSIG "
      if [ $nblinesHDR != $nblinesSIG ]; then
#do the header extraction
#build signal files list 
#loop on signal files
	  $ECHO "(DEBUG) (${scriptName}):  ${listOfsig[@]}"

	  for sigfname in ${listOfsig[@]}
	    do
	    filename=$(basename $sigfname)
	    extension=${filename##*.}
	    filename=${filename%.*}
            number=`$ECHO $filename | $AWK '{len=length("signal");len=len+1;a=substr($1,len);print a}'`
	    hdrname="header${number}.txt"
#look if header file already exists: if so skip it
	    hdrIsthere=`ils ${i}/${fibdir}/${hdrname} 2>&1 | $GREP -i "^ERROR" | $WC -l`
	    $ECHO "(DEBUG) (${scriptName}): look if ${hdrname}  exist (${hdrIsthere})"
	    if [ $hdrIsthere -eq 0 ]; then 
		continue
	    fi
#get the signal file
	    $ECHO "DEBUG (${scriptName}): iget $sigfname (dgg = ${nloop4dbg})"
            OUT3=./igetlog${nloop4dbg}.$$
	    iget -f -v -K ${i}/${fibdir}/${sigfname} . >${OUT3} 2>&1
	    igetStatus=`$GREP "^ERROR" ${OUT3}`
	    if [ "<$igetStatus>" != "<>" ]; then
		$ECHO "INFO (${scriptName}): error while iget:"
		$ECHO $igetStatus
		continue
	    fi
            $RM $OUT3
#extract the header part of the  signal file
	    $ECHO "DEBUG (${scriptName}): get header from ${sigfname} and put it in ${hdrname}"
	    IFS=$defaultIFS
	    while read -n80 L
	      do
	      [ "${L::3}" = "END" ] && break
	      $ECHO $L
	    done < ${sigfname} > ${hdrname}
	    $RM ${sigfname}
	    nhdrlines=`$WC -l ${hdrname} | $AWK '{print $1}' `
	    if [  "${nhdrlines}" = "0"  ]; then
		$ECHO "WARNING (${scriptName}): ${sigfname} has no valid header"
	    else
#transfert to irod the header
		$ECHO "INFO (${scriptName}): transfert ${hdrname} to ${i}/${fibdir}"
#use -f option ONLY to force override
		iput  -v -K ${hdrname} ${i}/${fibdir}
	    fi
            $RM ${hdrname}
	    nloop4dbg=$(expr $nloop4dbg + 1)
	  done
      else
	  $ECHO "INFO (${scriptName}): nothing to do for ${i}/${fibdir}"
      fi
  done
done
