#!/bin/sh -xv

scriptName="`basename $0`"
echo "Processing script ${scriptName} at `date`"

#Process cmd line args: the -src option is mandatory (source name as Abell85)
sourceRadio
freqBAOCalib=
bwBAOCalib=
#use -sim option to simulate processing (debug the script as if...)
simulationMode=""
while [ $# -gt 0 ]
do
  case "$1" in
      -src)  sourceRadio="$2"; shift;;
      -freq) freqBAOCalib="-freq $2"; shift;;
      -bwd)  bwBAOCalib="-bwd $2"; shift;;
      -sim) 
      simulationMode="-sim On"
      $ECHO "INFO ${scriptName} running in SIMUL mode"
      shift;;
	-h)
	echo >&2 \
	    "usage: $0 -src souce [-freq freq in MHz (default ${freqBAOCalib})] [-bwd bandwidth in MHz (default ${bwBAOCalib})]"
	exit 1;;
	*)  break;;	# terminate while loop
    esac
    shift
done


if [ "<${sourceRadio}>" = "<>" ]; then
    $ECHO "FATAL: You have forgotten to select the source option (-src)"
    exit 1
fi


jobBatchName="calibs-${sourceRadio}"

jobLogName="${jobBatchName}.log.$$"

qsub -l u_sps_baoradio,u_irods,T=120000,M=1000MB,scratch=1000MB,platform=LINUX -eo -o $jobLogName -N $jobBatchName -mb -me -mu campagne@lal.in2p3.fr <<EOF
/afs/in2p3.fr/home/c/campagne/private/work/calibmaker.sh  -src ${sourceRadio} ${freqBAOCalib} ${bwBAOCalib} ${simulationMode}
EOF
