#!/bin/sh
#download SCA file, proceed to introspection, and upload results
DATE=/bin/date
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
WC=/usr/bin/wc
CAT=/bin/cat
PRINTF=/usr/bin/printf
MKDIR=/bin/mkdir
RM=/bin/rm
LS=/bin/ls
DefaultIFS=$' \t\n'
IFS=$DefaultIFS


#set Irods environment    
. /usr/local/shared/bin/irods_env.sh -noverbose

scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"

#which source to analyse
sourceRadio=$1

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"

#temporary files to synchronize scripts
tmppublicpath=${TMPPUBLICPATH}
$LS -l ${tmppublicpath} > /dev/null


#Path where the job will do temporary IO
if [ ${ENVIRONMENT} = "INTERACTIVE" ]; then
    iojobpath="/sps/baoradio/AmasNancay/JEC"
    $MKDIR -p $iojobpath
elif [ ${ENVIRONMENT} = "BATCH" ] ; then
    iojobpath=${TMPBATCH}
else
    $ECHO "FATAL (${scriptName}): environment is ${ENVIRONMENT} not allowed"
    touch ${tmppublicpath}/scaIsOk.finished
    exit 1
fi
cd ${iojobpath}


localpath="${sourceRadio}"
$MKDIR -p ./${localpath}
cd ./${localpath}


#Path of the utility scripts
scriptpath="/afs/in2p3.fr/home/c/campagne/private/work/AmasNancay"


#get the daq current irod status
tag=`${DATE} +%F`
OUT1=${publicpath}/baodaqstatus-${tag}.txt
OUT1=${publicpath}/baodaqstatus-2011-09-11.txt

if [ ! -e ${OUT1} -o ! -r ${OUT1} ]; then
    $ECHO "FATAL (${scriptName}): ${OUT1} is missing or not readable..."
    touch ${tmppublicpath}/scaIsOk.finished
    exit 1
fi

if [ ! "<${sourceRadio}>" = "<>" ]; then
    $ECHO "You have selected sourceRadio = $sourceRadio"
    tableau=( `$GREP -i ${sourceRadio} ${OUT1} | $AWK '( NF==4 ) { print $2 }' ` )
else
    tableau=( `$CAT ${OUT1} | $GREP -i "baoradio" | $AWK '( NF==4 ) { print $2 }'`  )
fi
IFS='
'
tableau=( $( $PRINTF "%s\n" "${tableau[@]}" | $AWK 'x[$0]++ == 0' ) )
IFS=$DefaultIFS

for i in ${tableau[@]}
do
#scrutinize irods directory
#Nb: we do not care here if ILS returns non unique instance of a file
  scafile=`ils -l $i 2>&1 | $GREP -i "sca[0-9][0-9]*\.[0-9][0-9]*" | $AWK '{print $NF}'`
  if [ "<${scafile}>" = "<>" ]; then
      $ECHO "INFO (${scriptName}): Cannot download a SCA file for `basename $i`"
  fi
done
