#!/bin/sh -xvf
#download SCA file, proceed to introspection, and upload results
DATE=/bin/date
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
WC=/usr/bin/wc
CAT=/bin/cat
PRINTF=/usr/bin/printf
MKDIR=/bin/mkdir
RM=/bin/rm
LS=/bin/ls
DefaultIFS=$' \t\n'
IFS=$DefaultIFS


#set Irods environment    
. /usr/local/shared/bin/irods_env.sh -noverbose

scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"

#which source to analyse
sourceRadio=$1

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"

#temporary files to synchronize scripts
tmppublicpath="/sps/baoradio/AmasNancay"
$LS -l ${tmppublicpath} > /dev/null


#Path where the job will do temporary IO
if [ ${ENVIRONMENT} = "INTERACTIVE" ]; then
    iojobpath="/sps/baoradio/AmasNancay/JEC"
    $MKDIR -p $iojobpath
elif [ ${ENVIRONMENT} = "BATCH" ] ; then
    iojobpath=${TMPBATCH}
else
    $ECHO "FATAL (${scriptName}): environment is ${ENVIRONMENT} not allowed"
    touch ${tmppublicpath}/scaextractor.finished
    exit 1
fi
cd ${iojobpath}


localpath="${sourceRadio}"
$MKDIR -p ./${localpath}
cd ./${localpath}


#Path of the utility scripts
scriptpath="/afs/in2p3.fr/home/c/campagne/private/work/AmasNancay"


#get the daq current irod status
tag=`${DATE} +%F`
OUT1=${publicpath}/baodaqstatus-${tag}.txt

if [ ! -e ${OUT1} -o ! -r ${OUT1} ]; then
#    $ECHO "We should bring the DAQ status more up to date, this take 1 or 2sec..."
#    $RM -f ${tmppublicpath}/statusdaq.finished
#    ${scriptpath}/statusdaq.sh > ${OUT1}
#    while [ ! -f "${tmppublicpath}/statusdaq.finished" ]; do
#	$ECHO "INFO (${scriptName}); waiting for ${tmppublicpath}/statusdaq.finished"
#	date +%T
#	sleep 30 
#    done
#    $RM ${tmppublicpath}/statusdaq.finished
    $ECHO "FATAL (${scriptName}): ${OUT1} is missing or not readable..."
    touch ${tmppublicpath}/scaextractor.finished
    exit 1
fi

if [ ! "<${sourceRadio}>" = "<>" ]; then
    $ECHO "You have selected sourceRadio = $sourceRadio"
    tableau=( `$GREP -i ${sourceRadio} ${OUT1} | $AWK '( NF==4 ) { print $2 }' ` )
else
    tableau=( `$CAT ${OUT1} | $AWK'( NF==4 ) { print $2 }'`  )
fi
IFS='
'
tableau=( $( $PRINTF "%s\n" "${tableau[@]}" | $AWK 'x[$0]++ == 0' ) )
IFS=$DefaultIFS

for i in ${tableau[@]}
do
OUT2=./baodir.$$
#scrutinize irods directory
#Nb: we do not care here if ILS returns non unique instance of a file
  ils -l $i 2>&1 | $GREP -i "sca" > ${OUT2}
  $CAT ${OUT2}
#test if the SCA file has been already processed
  scatrans=`$GREP -i "sca.*\.sum\.trans" ${OUT2} | $AWK '{print $NF}'`
#test if the file is empty due to previous processing dysfunction
  emptyfile=`$GREP -i "sca.*\.sum\.trans" ${OUT2} | $AWK '{print $4}'`
#  echo "scrutinize directory <$i>: [$nblines] [$scatrans]" 
  if [ "<${scatrans}>" = "<>" -o "<${emptyfile}>" = "<0>" ]; then
      $ECHO "$i may be non prepared for analysis..."
      scafile=`$GREP -i "sca[0-9][0-9]*\.[0-9][0-9]*" ${OUT2} | $AWK '{print $NF}'`
      if [ "<${scafile}>" = "<>" ]; then
	  $ECHO "WARNING (${scriptName}): Cannot download a SCA file for $i"
      else
#get sca file
        iget -r -f -v -K ${i}/${scafile} ${iojobpath}
#extract summary (sum extension)
	$RM -f ${tmppublicpath}/sca.finished
	${scriptpath}/sca.sh ${scafile}
	while [ ! -e "${tmppublicpath}/sca.finished" ]; do
	    $ECHO "INFO (${scriptName}); waiting for ${tmppublicpath}/sca.finished"
	    date +%T
	    sleep 30
	done
	$ECHO "INFO (${scriptName}): sca.sh has finished"
	$RM ${tmppublicpath}/sca.finished
#TODO see if there is errors...
        scaFileName=$(basename $scafile)
	scaFileName=${scaFileName%.*}
#transform the date (sum.trans extension)
	$RM -f ${tmppublicpath}/transdate.finished
        ${scriptpath}/transdate.sh ${scaFileName}.sum
	while [ ! -e "${tmppublicpath}/transdate.finished" ]; do
	    $ECHO "INFO (${scriptName}); waiting for ${tmppublicpath}/transdate.finished"
	    date +%T
	    sleep 30
	done
	$ECHO "INFO (${scriptName}): transdate.sh  has finished"
	$RM ${tmppublicpath}/transdate.finished
#TODO see if there is errors...	
#put back into Irod
#	$ECHO "INFO (${scriptName}): where am i: `pwd`"
#	$LS -lrt
#	$ECHO "INFO (${scriptName}): see up directory"
#	$LS -lrt ..
	iput -f -v -K ${iojobpath}/${scaFileName}.sum $i
	iput -f -v -K ${iojobpath}/${scaFileName}.sum.trans $i
      fi
  fi
$RM ${OUT2}
done


touch ${tmppublicpath}/scaextractor.finished
exit 0
