#!/bin/sh
#liste des "sources" enregistrees sous Amas
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
MKDIR=/bin/mkdir
CAT=/bin/cat
PRINTF=/usr/bin/printf
LS=/bin/ls
RM=/bin/rm
SORT=/bin/sort
XARGS=/usr/bin/xargs
DefaultIFS=$' \t\n'
IFS=$DefaultIFS


# Irods environment settings
. /usr/local/shared/bin/irods_env.sh -noverbose

scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"


#temporary files to synchronize scripts
tmppublicpath="/sps/baoradio/AmasNancay"
$LS -l ${tmppublicpath} > /dev/null


#Path where the job will do temporary IO
if [ ${ENVIRONMENT} == "INTERACTIVE" ]; then
    iojobpath="/sps/baoradio/AmasNancay/JEC"
    $MKDIR -p $iojobpath
elif [ ${ENVIRONMENT} == "BATCH" ] ; then
    iojobpath=${TMPBATCH}
else
    $ECHO "FATAL (${scriptName}): environment is ${ENVIRONMENT} not allowed"
    touch ${tmppublicpath}/statusdaq.finished
    exit 1
fi
cd ${iojobpath}


OUT1=./baoils.$$
ils /baoradio/data/AmasNancay/ > ${OUT1}
OUT2=./baoawk1.$$
$AWK '($1=="C-") {print $2}' ${OUT1} > ${OUT2}
$RM $OUT1

#Sequence 
tableau=( `$CAT $OUT2 | $AWK '{print $1}'` )
IFS='
'
tableau=( $( $PRINTF "%s\n" "${tableau[@]}" | $AWK 'x[$0]++ == 0' ) )
IFS=$DefaultIFS

$RM $OUT2

for i in ${tableau[@]}
do
  $ECHO "source $i"
  listedate=( `ils $i | $AWK '($1=="C-"){print $2}'`)
  IFS='
'
  listedate=( $( $PRINTF "%s\n" "${listedate[@]}" | $AWK 'x[$0]++ == 0' ) )
  IFS=$DefaultIFS

  ntotfiles=0
  for j in ${listedate[@]}
  do
#Nb: care should be taken to the possible instances of a file returned by ILS
    listOfsig=( `ils ${j}/Fiber1 | $GREP -i "signal" | $XARGS -i basename {} | $SORT -k1.7n` )
    IFS='
  '
    listOfsig=( $( $PRINTF "%s\n" "${listOfsig[@]}" | $AWK 'x[$0]++ == 0' ) )
    IFS=$DefaultIFS
    nfiles=${#listOfsig[@]}
    $ECHO ">>> $j ---> $nfiles"
    let "ntotfiles=ntotfiles+nfiles"
  done 
  $ECHO "total files = $ntotfiles"

done

touch ${tmppublicpath}/statusdaq.finished
exit 0
