#!/bin/sh

#Process cmd line args: the -src option is mandatory (source name as Abell85)
sourceRadio=
while [ $# -gt 0 ]
do
  case "$1" in
      -src)  sourceRadio=$2; shift;;
	-h)
	    echo >&2 \
	    "usage: $0 -src souce"
	    exit 1;;
	*)  break;;	# terminate while loop
    esac
    shift
done

jobBatchName="headerMaker-$sourceRadio"
jobLogName="${jobBatchName}.log.$$"

qsub -l u_sps_baoradio,u_irods,T=100000,M=256MB,scratch=700MB,platform=LINUX -eo -o $jobLogName -N $jobBatchName -mb -me -mu campagne@lal.in2p3.fr <<EOF
/afs/in2p3.fr/home/c/campagne/private/work/AmasNancay/hdrfitsextractor.sh  $sourceRadio
EOF
