#!/bin/sh -xvf
DATE=/bin/date
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
WC=/usr/bin/wc
CAT=/bin/cat
PRINTF=/usr/bin/printf
FIND=/usr/bin/find
MKDIR=/bin/mkdir
XARGS=/usr/bin/xargs
SORT=/bin/sort
RM=/bin/rm
TR=/usr/bin/tr
CP=/bin/cp
LS=/bin/ls
CHMOD=/bin/chmod

#Process cmd line args: the -src option is mandatory (source name as Abell85)
sourceRadio=
while [ $# -gt 0 ]
do
  case "$1" in
      -src)  sourceRadio=$2; shift;;
	-h)
	    echo >&2 \
	    "usage: $0 -src souce"
	    exit 1;;
	*)  break;;	# terminate while loop
    esac
    shift
done

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"


#temporary files to synchronize scripts
tmppublicpath=${TMPPUBLICPATH}
$LS -l ${tmppublicpath} > /dev/null

#Path of the utility scripts
scriptpath="/afs/in2p3.fr/home/c/campagne/private/work/AmasNancay"

#the daq current irod status
tag=`${DATE} +%F`
OUT1=${publicpath}/baodaqstatus-${tag}.txt

if [ ! -e ${OUT1}  -o ! -r ${OUT1} ]; then
    $ECHO "We should bring the DAQ status more up to date, this take 1 or 2sec..."
    $RM -f ${tmppublicpath}/statusdaq.finished
    ${scriptpath}/statusdaq.sh > ${OUT1}
    while [ ! -f "${tmppublicpath}/statusdaq.finished" ]; do
	sleep 30
    done
    $RM ${tmppublicpath}/statusdaq.finished
#protect against remove/rewriting    
    $CHMOD -v 444 ${OUT1} 
fi

jobBatchName="scaMaker-$sourceRadio"
jobLogName="${jobBatchName}.log.$$"

qsub -l u_sps_baoradio,u_irods,T=100000,M=256MB,scratch=700MB,platform=LINUX -eo -o $jobLogName -N $jobBatchName -mb -me -mu campagne@lal.in2p3.fr <<EOF
/afs/in2p3.fr/home/c/campagne/private/work/AmasNancay/scaextractor.sh  $sourceRadio
EOF
