// Utilisation de SOPHYA pour faciliter les tests ...
#include <regex.h>
//#include <regexp.h>
#include <stdio.h>

#include "sopnamsp.h"
#include "machdefs.h"

#include <stdlib.h>
#include <dirent.h>
#include <matharr.h>

// include standard c/c++
#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <map>
#include <functional>
#include <algorithm>
#include <numeric>
#include <list>
#include <exception>

// include sophya mesure ressource CPU/memoire ...
#include "resusage.h"
#include "ctimer.h"
#include "timing.h"
#include "timestamp.h"
#include "strutilxx.h"
#include "ntuple.h"
#include "fioarr.h"
#include "tarrinit.h"
#include "histinit.h"
#include "fitsioserver.h"
#include "fiosinit.h"
#include "ppersist.h"

//-----------------------------------------------
char *regexp (const char *string, const char *patrn, int *begin, int *end) {    
        int i, w=0, len;                 
        char *word = NULL;
        regex_t rgT;
        regmatch_t match;
        regcomp(&rgT,patrn,REG_EXTENDED);
        if ((regexec(&rgT,string,1,&match,0)) == 0) {
                *begin = (int)match.rm_so;
                *end = (int)match.rm_eo;
                len = *end-*begin;
                word=(char*)malloc(len+1);
                for (i=*begin; i<*end; i++) {
                        word[w] = string[i];
                        w++; }
                word[w]=0;
        }
        regfree(&rgT);
        return word;
}
//------------------------------------------------ 


struct Param {
  string debuglev_;
  string inPath_;
  string outPath_;
  string sourceName_;
  string ppfFile_;
} para;
//-----
sa_size_t round_sa(r_4 r) {
  return static_cast<sa_size_t>((r > 0.0) ? (r + 0.5) : (r - 0.5));
}
//-----
string StringToLower(string strToConvert){
  //change each element of the string to lower case
  for(unsigned int i=0;i<strToConvert.length();i++) {
    strToConvert[i] = tolower(strToConvert[i]);
  }
  return strToConvert;//return the converted string
}
//-----
bool stringCompare( const string &left, const string &right ){
   if( left.size() < right.size() )
      return true;
   for( string::const_iterator lit = left.begin(), rit = right.begin(); lit != left.end() && rit != right.end(); ++lit, ++rit )
      if( tolower( *lit ) < tolower( *rit ) )
         return true;
      else if( tolower( *lit ) > tolower( *rit ) )
         return false;
   return false;
}
//-----
list<string> ListOfFileInDir(string dir, string filePettern) throw(string) {
  list<string> theList;


  DIR *dip;
  struct dirent *dit;
  string msg;  string fileName;
  string fullFileName;
  size_t found;

  if ((dip=opendir(dir.c_str())) == NULL ) {
    msg = "opendir failed on directory "+dir;
    throw msg;
  }
  while ( (dit = readdir(dip)) != NULL ) {
    fileName = dit->d_name;
    found=fileName.find(filePettern);
    if (found != string::npos) {
      fullFileName = dir + "/";
      fullFileName += fileName;
      theList.push_back(fullFileName);
    }
  }//eo while
  if (closedir(dip) == -1) {
    msg = "closedir failed on directory "+dir;
    throw msg;
  }
  
  theList.sort(stringCompare);

  return theList;

}
//
class  StringMatch : public unary_function<string,bool> {
public:
  StringMatch(const string& pattern): pattern_(pattern){}
  bool operator()(const string& aStr) const {


    int b,e;
    regexp(aStr.c_str(),pattern_.c_str(),&b,&e);

//     cout << "investigate " << aStr << " to find " << pattern_ 
// 	 << "[" <<b<<","<<e<<"]" 
// 	 << endl;

    
    if (b != 0) return false;
    if (e != aStr.size()) return false;
    return true;

  }
private:
  string pattern_;
};
//-------------------------------------------------------
//-------------------------------------------------------
void meanOnCycles() throw(string) {
  list<string> listOfFiles;
  string directoryName;
  directoryName = para.inPath_ + "/" + para.sourceName_;

  listOfFiles = ListOfFileInDir(directoryName,para.ppfFile_);
  
  list<string>::const_iterator iFile, iFileEnd, iSpec, iSpecEnd;
  iFileEnd = listOfFiles.end();
  
  StringMatch match("specONOFFRaw[0-9]+");
  for (iFile = listOfFiles.begin(); iFile != iFileEnd; ++iFile) {
    cout << "load file <" << *iFile << ">" << endl;
    PInPersist fin(*iFile);
    vector<string> vec = fin.GetNameTags();
    list<string> listOfSpectra;
    std::remove_copy_if(
			vec.begin(), vec.end(), back_inserter(listOfSpectra),
			not1(match)
			);
   
    iSpecEnd = listOfSpectra.end();
    listOfSpectra.sort(stringCompare);

    for (iSpec = listOfSpectra.begin(); iSpec !=iSpecEnd;  ++iSpec){
      cout << " spactra <" << *iSpec << ">" << endl;
    }

  }
  
}
//-------------------------------------------------------
int main(int narg, char* arg[])
{
  
  int rc = 0; //return code
  string msg; //message used in Exceptions


  string debuglev = "0";
  string action = "default";
  string inputPath = "."; 
  string outputPath = "."; 
  string sourceName = "Abell85";
  string ppfFile;
 
  
  //  bool okarg=false;
  int ka=1;
  while (ka<(narg-1)) {
    if (strcmp(arg[ka],"-debug")==0) {
      debuglev=arg[ka+1];
      ka+=2;
    }
    else if (strcmp(arg[ka],"-act")==0) {
      action=arg[ka+1];
      ka+=2;
    }
    else if (strcmp(arg[ka],"-inPath")==0) {
      inputPath=arg[ka+1];
      ka+=2;
    }
    else if (strcmp(arg[ka],"-outPath")==0) {
      outputPath=arg[ka+1];
      ka+=2;
    }
    else if (strcmp(arg[ka],"-src")==0) {
      sourceName=arg[ka+1];
      ka+=2;
    }
    else if (strcmp(arg[ka],"-ppfFile")==0) {
      ppfFile=arg[ka+1];
      ka+=2;
    }
    else ka++;
  }//eo while

  para.debuglev_ = debuglev;
  para.inPath_   = inputPath;
  para.outPath_  = outputPath;
  para.sourceName_ = sourceName;
  para.ppfFile_ = ppfFile;

  cout << "Dump Initial parameters ............" << endl;
  cout << " action = " << action << "\n"
       << " inputPath = " << inputPath << "\n" 
       << " outputPath = " << outputPath << "\n"
       << " sourceName = " << sourceName << "\n"
       << " ppfFile = " << ppfFile << "\n"
       << " debuglev = "  << debuglev  << "\n";
  cout << "...................................." << endl;

  if ( "" == ppfFile ) {
    cerr << "mergeRawOnOff.cc: you have forgotten ppfFile option"
	 << endl;
    return 999;
  }


  try {

    int b,e;
    char *match=regexp("truc0machin","[a-z]+[0-9]*",&b,&e);
    printf("->%s<-\n(b=%d e=%d)\n",match,b,e);

    if ( action == "default" ) {
      meanOnCycles();
    }

  }  catch (std::exception& sex) {
    cerr << "mergeRawOnOff.cc std::exception :"  << (string)typeid(sex).name() 
	 << "\n msg= " << sex.what() << endl;
    rc = 78;
  }
  catch ( string str ) {
    cerr << "mergeRawOnOff.cc Exception raised: " << str << endl;
  }
  catch (...) {
    cerr << "mergeRawOnOff.cc catched unknown (...) exception  " << endl; 
    rc = 79; 
  } 

  return 0;

}
