#!/bin/sh
#
#Script sh d'extraction de fichier SCA des sequances Diodes a Bruit (DAB) 
#et Data des cycles ON/OFF
#Bash script that extract from SCA files the DAB/DATA phases in ON/OFF cycles
#It is supposed that the sequence is: DAB1 DATA1 DAB2 DATA2
#and that the DAB1 and DAB2 have equal number of subsequences
# Auteur: JE Campagne (LAL Orsay)
# Creation: 11 Avril 2011
# Revision: 12 Avril 2011
#  o 12/04/11: mv date format to %Y-%m-%d %T for further treatment by 'date' 
#              system function 

#Basic tuning of system fuction used.
AWK=/bin/awk
SED=/bin/sed
GREP=/bin/grep
WC=/usr/bin/wc 
RM=/bin/rm
CAT=/bin/cat
TOUCH=/bin/touch
DATE=/bin/date
ECHO=/bin/echo
LS=/bin/ls
MKDIR=/bin/mkdir
DefaultIFS=$' \t\n'
IFS=$DefaultIFS


scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"

#temporary files to synchronize scripts
tmppublicpath=${TMPPUBLICPATH}
$LS -l ${tmppublicpath} > /dev/null

#Path where the job will do temporary IO
if [ ${ENVIRONMENT} = "INTERACTIVE" ]; then
    iojobpath="/sps/baoradio/AmasNancay/JEC"
    $MKDIR -p $iojobpath
elif [ ${ENVIRONMENT} = "BATCH" ] ; then
    iojobpath=${TMPBATCH}
else
    $ECHO "FATAL (${scriptName}): environment is ${ENVIRONMENT} not allowed"
#JEC 29/9/11 avoid finished stuff
#    touch ${tmppublicpath}/sca.finished
    exit 1
fi
cd ${iojobpath}


if [ ! $# = 1 ]
    then
    $ECHO "FATAL  (${scriptName}): usage: ./sca.sh <file>"
#JEC 29/9/11 avoid finished stuff
#    touch ${tmppublicpath}/sca.finished
    exit 1
fi


fullfile=$1
if [ ! -e $fullfile ] 
    then
    $ECHO "FATAL (${scriptName}): $fullfile not found: FATAL"
#JEC 29/9/11 avoid finished stuff
#    touch ${tmppublicpath}/sca.finished
    exit 1
fi

#The output file would be in "fullprocfile"
filename=$(basename $fullfile)
#extension=${filename##*.}
filename=${filename%.*}
extension=".sum"
fullprocfile=${filename}${extension}
#create empty output file
$RM -f $fullprocfile
$TOUCH $fullprocfile


#extract the PERI lines valid for DAB and DATA
OUT1=./tmp1.$$
$AWK '
$1=="PERI" {
   print "CYCLE",$6,$2,$3,$7,$8
  }
' $fullfile > $OUT1


#Sequence of the cycle numbers (perform a unique filtering)
tableau=( `cat $OUT1 | $AWK '{print $2}'` )
IFS='
'
tableau=( $( printf "%s\n" "${tableau[@]}" | awk 'x[$0]++ == 0' ) )
IFS=$DefaultIFS

#scan each cycle
OUT2=./tmp2.$$
for i in ${tableau[@]}
do
#extract the DAB calibration phases. Hypothesis: 2 identical sequences 
  CALIB=./tmp_cycle_${i}_calib.$$
  $AWK -v cycle=$i '$2==cycle && $5=="-1" {print $0} ' $OUT1 > $CALIB
  nlines=`$WC $CALIB | $AWK '{print $1}'`
  start1=1
  let "end1=nlines/2"
  let "start2=end1+1"
  end2=$nlines

#date Start/End of DAB1 
  $SED -e "${start1}!d" $CALIB | $AWK -v cycle=$i 'BEGIN {ORS=","} {
    split($4,b,".");   
    print cycle "," $3,b[1]}' >> ${OUT2}
  $SED -e "${end1}!d"   $CALIB | $AWK 'BEGIN {ORS=","} {
    split($4,b,".");   
    print $3,b[1]}' >> ${OUT2}


#date Start/End of DATA1: use date system function to add the duration to
#compute the End,cf. End = Start + duration 
  $AWK -v datesys=$DATE -v cycle=$i '$2==cycle && ( $5=="1" ) {
    split($3,a,"/"); 
    split($4,b,".");   
    dateStart=a[2]"/"a[1]"/"a[3] " " b[1];
    duree=$6 " sec";
    cmd=sprintf("%s --date \"%s %s\"  \"+%%d/%%m/%%y %%T\" ",datesys,dateStart,duree);
   (cmd | getline dateEnd);
    close(cmd);  
    ORS=","; print a[1]"/"a[2]"/"a[3] " " b[1];
    ORS=","; print dateEnd;
  } ' $OUT1 >> ${OUT2}
 
#same as DAB1 for DAB2
  $SED -e "${start2}!d" $CALIB | $AWK 'BEGIN {ORS=","} {
    split($4,b,".");   
    print $3,b[1]}' >> ${OUT2}
  $SED -e "${end2}!d"   $CALIB | $AWK 'BEGIN {ORS=","} {
     split($4,b,".");   
     print $3,b[1]}' >> ${OUT2}
#same as DATA1 for DATA2
  $AWK -v datesys=$DATE -v cycle=$i '$2==cycle && ( $5=="2" ) {
    split($3,a,"/"); 
    split($4,b,".")   
    dateStart=a[2]"/"a[1]"/"a[3] " " b[1];
    duree=$6 " sec";
    cmd=sprintf("%s --date \"%s %s\"  \"+%%d/%%m/%%y %%T\" ",datesys,dateStart,duree);
   (cmd | getline dateEnd);
    close(cmd);  
    ORS=","; print a[1]"/"a[2]"/"a[3] " " b[1];
    ORS="\n"; print  dateEnd;
  } ' $OUT1 >> ${OUT2}
#clean
  $RM $CALIB
done

#transform all the date/time into %Y-%m-%d %T
$AWK -v datesys=$DATE ' 
BEGIN { FS=","; OFS="," }
{
  for (i=2;i<=NF;i++) {
    split($i,a,"/");
    newdate=a[2]"/"a[1]"/"a[3];
    cmd=sprintf("%s --date \"%s\" \"+%%Y-%%m-%%d %%T\" ",datesys,newdate);
    (cmd | getline newdate);
    close(cmd);
    $i=newdate;
  } 
  print $0;
}' ${OUT2} > ${fullprocfile}


#clean
$RM $OUT1
$RM $OUT2

#JEC 29/9/11 avoid finished stuff
#touch ${tmppublicpath}/sca.finished
exit 0



