#!/bin/sh
#Status de l'etat de la production des fichiers INPUT de calibrations
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
MKDIR=/bin/mkdir
CAT=/bin/cat
PRINTF=/usr/bin/printf
RM=/bin/rm
SORT=/bin/sort
XARGS=/usr/bin/xargs
WC=/usr/bin/wc
DefaultIFS=$' \t\n'
IFS=$DefaultIFS

# Irods environment settings
. /usr/local/shared/bin/irods_env.sh -noverbose

scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"

#Path where the job will do temporary IO
if [ ${ENVIRONMENT} == "INTERACTIVE" ]; then
    iojobpath="/sps/baoradio/AmasNancay/JEC"
    $MKDIR -p $iojobpath
elif [ ${ENVIRONMENT} == "BATCH" ] ; then
    iojobpath=${TMPBATCH}
else
    $ECHO "FATAL (${scriptName}): environment is ${ENVIRONMENT} not allowed"
    exit 1
fi
cd ${iojobpath}


OUT1=./baoils.$$
ils /baoradio/data/AmasNancay/ > ${OUT1}
OUT2=./baoawk1.$$
$AWK '($1=="C-") {print $2}' ${OUT1} > ${OUT2}
$RM $OUT1
#Sequence 
listeSources=( `$CAT $OUT2 | $AWK '{print $1}'` )
IFS='
'
listeSources=( $( $PRINTF "%s\n" "${listeSources[@]}" | $AWK 'x[$0]++ == 0' ) )
IFS=$DefaultIFS
$RM $OUT2

for i in ${listeSources[@]}
do
#nb: $i contains the full path
  $ECHO "source ${i}"
  sourceName=`basename ${i}`
  listeDates=( `ils $i | $AWK '($1=="C-"){print $2}'`)
  IFS='
'
  listeDates=( $( $PRINTF "%s\n" "${listeDates[@]}" | $AWK 'x[$0]++ == 0' ) )
  IFS=$DefaultIFS

  for j in ${listeDates[@]}
  do
#nb: $j contains the full path
#  $ECHO "run ${j}"
#
#Off directory
#
    dateField=`basename ${j}`
    sourceDate="${sourceName}-${dateField}"
#look if final data processing files exist
    onOffOk=`ils ${j} | $GREP -i "data.*\.ppf\|diff.*\.ppf" | $WC -l`
    offDirExist=`ils ${j} | $GREP -i "Off" | $WC -l`
    if [ ${offDirExist} != 0 ]; then
	listeCyclesOff=( `ils ${j}/Off | $GREP -i "datacycle" | $AWK '($1=="C-"){print $2}' | $XARGS -i basename {} | $SORT -k1.11n` )
	IFS='
  '
	listeCyclesOff=( $( $PRINTF "%s\n" "${listeCyclesOff[@]}" | $AWK 'x[$0]++ == 0' ) )
	IFS=$DefaultIFS
	
	if [ ${#listeCyclesOff[*]} != 0 ]; then    
           for c in ${listeCyclesOff[@]}
	   do
#nb: $c has the format of datacycle<number>
	     nFiles=`ils ${j}/Off/${c} | $GREP -i "medfiltmtx" | $WC -l`
	     if [ ${nFiles} != 0 ]; then
		 $ECHO "${sourceDate}/Off/${c}: ${nFiles} spectra (${onOffOk} ana)"
	     else
		 $ECHO "${sourceDate}/Off/${c}: ON-OFF failed"
	     fi
#end of loop on cycles 
	   done
	else
	    $ECHO "${sourceDate} : No ON-OFF done for Off Diectory"
	fi
#end of Off exist
    else
	$ECHO "${sourceDate} : No Off Diectory"
    fi
#
#On directory
#
    dateField=`basename ${j}`
    sourceDate="${sourceName}-${dateField}"
#look if final calibration files exist
    onOnOk=`ils ${j} | $GREP -i "data.*\.ppf\|diff.*\.ppf" | $WC -l`
    onDirExist=`ils ${j} | $GREP -i "On" | $WC -l`
    if [ ${onDirExist} != 0 ]; then
	listeCyclesOn=( `ils ${j}/On | $GREP -i "datacycle" | $AWK '($1=="C-"){print $2}' | $XARGS -i basename {} | $SORT -k1.11n` )
	IFS='
  '
	listeCyclesOn=( $( $PRINTF "%s\n" "${listeCyclesOn[@]}" | $AWK 'x[$0]++ == 0' ) )
	IFS=$DefaultIFS
	
	if [ ${#listeCyclesOn[*]} != 0 ]; then    
           for c in ${listeCyclesOn[@]}
	   do
#nb: $c has the format of datacycle<number>
	     nFiles=`ils ${j}/On/${c} | $GREP -i "medfiltmtx" | $WC -l`
	     if [ ${nFiles} != 0 ]; then
		 $ECHO "${sourceDate}/On/${c}: ${nFiles} spectra (${onOnOk} ana)"
	     else
		 $ECHO "${sourceDate}/On/${c}: ON-OFF failed"
	     fi
#end of loop on cycles 
	   done
	else
	    $ECHO "${sourceDate} : No ON-OFF done for On Diectory"
	fi
#end of On exist
    else
	$ECHO "${sourceDate} : No On Diectory"
    fi
#end of loop on dates
  done 
#end of loop on sources
done
