#!/bin/sh
#make an archive of the processing
DATE=/bin/date
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
WC=/usr/bin/wc
CAT=/bin/cat
PRINTF=/usr/bin/printf
FIND=/usr/bin/find
MKDIR=/bin/mkdir
XARGS=/usr/bin/xargs
SORT=/bin/sort
RM=/bin/rm
TR=/usr/bin/tr
CP=/bin/cp
LS=/bin/ls
CHMOD=/bin/chmod

DefaultIFS=$' \t\n'
IFS=$DefaultIFS

#set Irods environment    
. /usr/local/shared/bin/irods_env.sh -noverbose

scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"
#which source to analyse

#Process cmd line args: the -src option is mandatory (source name as Abell85)
sourceRadio=
dateSelected=
prependTag=""
appendTag=""
simulationMode=Off
while [ $# -gt 0 ]
  do
  case "$1" in
      -src)  sourceRadio=$2;    shift;;
      -date) dateSelected=$2;     shift;;
      -ppTag) prependTag=$2; shift;;
      -apTag) appendTag=$2; shift;;
      -sim)  simulationMode=On;;
      -h)
      echo >&2 \
	  "usage: $0 -src souce -date YYYYMMDD -ppTag <tag> -apTag <tag>  [-sim to trig simulation mode]"
      exit 1;;
      *)  break;;	# terminate while loop
  esac
  shift
done


if [ ${simulationMode} = "On" ]; then
    $ECHO "INFO ${scriptName} running in SIMUL mode"
fi

if [ "<${sourceRadio}>" = "<>" ]; then
    $ECHO "FATAL: You have forgotten to select the source option (-src)"
    exit 1
fi

if [ "<${prependTag}>" = "<>" -a "<${appendTag}>" = "<>"  ]; then
    $ECHO "FATAL: choose either a prepend Tag or a append Tag"
    exit
fi


case ${sourceRadio} in
    Abell85) $ECHO "INFO (${scriptName}): process ${sourceRadio}";;
    Abell2440) $ECHO "INFO (${scriptName}): process ${sourceRadio}";;
    Abell1205) $ECHO "INFO (${scriptName}): process ${sourceRadio}";;
    *) ECHO "FATAL (${scriptName}): process ${sourceRadio} not yet foreseen"
    exit 1;;
esac

srclower=`${ECHO} ${sourceRadio} | ${TR} "[:upper:]" "[:lower:]" `

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"


#temporary files to synchronize scripts
tmppublicpath=${TMPPUBLICPATH}
#wakeup the NFS disk
$LS -l ${tmppublicpath} > /dev/null

#Path where the job will do temporary IO
. ${SCRIPTPATH}/set_iojobpath.sh
iojobpath=$(set_iojobpath)
cd ${iojobpath}

localpath="${sourceRadio}"
$MKDIR -p ./${localpath}
cd ./${localpath}


#Path of the utility scripts
scriptpath=${SCRIPTPATH}

OUT1=${publicpath}/baodaqstatus-current.txt
if [ ! -e ${OUT1}  -o ! -r ${OUT1} ]; then
    $ECHO "FATAL (${scriptName}): ${OUT1} has a problem"
    exit 1
fi



$ECHO "You have selected sourceRadio = ${sourceRadio} [date = ${dateSelected}]"
tableau=( `$GREP -i "${dateSelected}${srclower}" ${OUT1} | $AWK '( NF==4 ) { print $2 }' ` )
IFS='
' 
tableau=( $( $PRINTF "%s\n" "${tableau[@]}" | $AWK 'x[$0]++ == 0' ) )
IFS=$DefaultIFS

$ECHO "We are in directory `pwd`"

for i in ${tableau[@]}
  do
#
  
  $ECHO "DEBUG: (${scriptName}) irods root dir $i"

  

  #make a new archive directory
  archiveDir=${prependTag}Arch${appendTag}

  archExist=`ils ${i} 2>&1 | $GREP -i ".*C-.*${archiveDir}"| $WC -l`
  if [ ${archExist} -gt 0 ]; then
      $ECHO "FATAL: ${archiveDir} already exit in ${i}"
      exit 1
  fi

  imkdir -v ${i}/${archiveDir}
  
  #Move the Off and On directory
  imv -v ${i}/Off ${i}/${archiveDir}/Off
  imv -v ${i}/On ${i}/${archiveDir}/On
  
  #recreate On and Off directories
  imkdir -v ${i}/Off 
  imkdir -v ${i}/On
 
  #mv the fichiers de calibrations BAO
  calibfiles=( `ils ${i} 2>&1 | $GREP -i "calib_.*\.txt" ` )
  IFS='
' 
  calibfiles=( $( $PRINTF "%s\n" "${calibfiles[@]}" | $AWK 'x[$0]++ == 0' )  )
  IFS=$DefaultIFS

  for j in ${calibfiles[@]}
    do
    file=`$ECHO $j`
    imv -v ${i}/${file} ${i}/${archiveDir}/${file}
  done
  
  #mv the ppf files
  ppffiles=( `ils ${i} 2>&1 | $GREP -i ".*\.ppf" ` )
  IFS='
' 
  ppffiles=( $( $PRINTF "%s\n" "${ppffiles[@]}" | $AWK 'x[$0]++ == 0' )  )
  IFS=$DefaultIFS

  for j in ${ppffiles[@]}
    do
    file=`$ECHO $j`
    imv -v ${i}/${file} ${i}/${archiveDir}/${file}
  done

  #save the gain file
  gainfile=`ils ${i} 2>&1 | $GREP -i "gain.*\.fits"`
  file=`$ECHO ${gainfile}`
  icp -v ${i}/${file} ${i}/${archiveDir}/${file}

done

exit 0