#!/bin/sh -xvf
#download SCA file, proceed to introspection, and upload results
DATE=/bin/date
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
WC=/usr/bin/wc
CAT=/bin/cat
PRINTF=/usr/bin/printf
MKDIR=/bin/mkdir
RM=/bin/rm
LS=/bin/ls
DefaultIFS=$' \t\n'
IFS=$DefaultIFS


#set Irods environment    
. /usr/local/shared/bin/irods_env.sh -noverbose

scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"

#which source to analyse
sourceRadio=$1

#force recomputation force=Yes
force=$2

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"

#temporary files to synchronize scripts
tmppublicpath=${TMPPUBLICPATH}
$LS -l ${tmppublicpath} > /dev/null


#Path where the job will do temporary IO
. ${SCRIPTPATH}/set_iojobpath.sh
iojobpath=$(set_iojobpath)
cd ${iojobpath}


localpath="${sourceRadio}"
$MKDIR -p ./${localpath}
cd ./${localpath}


#Path of the utility scripts
scriptpath=${SCRIPTPATH}


#JEC 1/10/11 Use generic baodaqstatus name 
#get the daq current irod status
#tag=`${DATE} +%F`
#OUT1=${publicpath}/baodaqstatus-${tag}.txt
OUT1=${publicpath}/baodaqstatus-current.txt


if [ ! -e ${OUT1} -o ! -r ${OUT1} ]; then
    $ECHO "FATAL (${scriptName}): ${OUT1} has a problem"
    exit 1
fi

if [ ! "<${sourceRadio}>" = "<>" ]; then
    $ECHO "You have selected sourceRadio = $sourceRadio"
    tableau=( `$GREP -i ${sourceRadio} ${OUT1} | $AWK '( NF==4 ) { print $2 }' ` )
else
    tableau=( `$CAT ${OUT1} | $AWK'( NF==4 ) { print $2 }'`  )
fi
IFS='
'
tableau=( $( $PRINTF "%s\n" "${tableau[@]}" | $AWK 'x[$0]++ == 0' ) )
IFS=$DefaultIFS

for i in ${tableau[@]}
do
OUT2=./baodir.$$
#scrutinize irods directory
#Nb: we do not care here if ILS returns non unique instance of a file
  ils -l $i 2>&1 | $GREP -i "sca" > ${OUT2}
  $CAT ${OUT2}
#test if the SCA file has been already processed
  scatrans=`$GREP -i "sca.*\.sum\.trans" ${OUT2} | $AWK '{print $NF}'`
#test if the file is empty due to previous processing dysfunction
  emptyfile=`$GREP -i "sca.*\.sum\.trans" ${OUT2} | $AWK '{print $4}'`
#  echo "scrutinize directory <$i>: [$nblines] [$scatrans]" 
  if [ "<${scatrans}>" = "<>" -o "<${emptyfile}>" = "<0>" -o "<${force}>" = "<Yes>" ]; then
      $ECHO "$i may be non prepared for analysis..."
      scafile=`$GREP -i "sca[0-9][0-9]*\.[0-9][0-9]*" ${OUT2} | $AWK '{print $NF}'`
      if [ "<${scafile}>" = "<>" ]; then
	  $ECHO "WARNING (${scriptName}): Cannot download a SCA file for $i"
      else
#get sca file
        iget -r -f -v -K ${i}/${scafile} ${iojobpath}
#extract summary (sum extension)
#JEC 29/9/11 avoid finished stuff
	$RM -f ${tmppublicpath}/sca.finished
	${scriptpath}/sca.sh ${scafile}
#	while [ ! -e "${tmppublicpath}/sca.finished" ]; do
#	    $ECHO "INFO (${scriptName}); waiting for ${tmppublicpath}/sca.finished"
#	    date +%T
#	    sleep 30
#	done
	$ECHO "INFO (${scriptName}): sca.sh has finished"
#	$RM ${tmppublicpath}/sca.finished
#TODO see if there is errors...
        scaFileName=$(basename $scafile)
	scaFileName=${scaFileName%.*}
#transform the date (sum.trans extension)
#JEC 29/9/11 avoid finished stuff
#	$RM -f ${tmppublicpath}/transdate.finished
        ${scriptpath}/transdate.sh ${scaFileName}.sum
#	while [ ! -e "${tmppublicpath}/transdate.finished" ]; do
#	    $ECHO "INFO (${scriptName}); waiting for ${tmppublicpath}/transdate.finished"
#	    date +%T
#	    sleep 30
#	done
	$ECHO "INFO (${scriptName}): transdate.sh  has finished"
#	$RM ${tmppublicpath}/transdate.finished
#TODO see if there is errors...	
#put back into Irod
#	$ECHO "INFO (${scriptName}): where am i: `pwd`"
#	$LS -lrt
#	$ECHO "INFO (${scriptName}): see up directory"
#	$LS -lrt ..
	iput -f -v -K ${iojobpath}/${scaFileName}.sum $i
	iput -f -v -K ${iojobpath}/${scaFileName}.sum.trans $i
      fi
  fi
$RM ${OUT2}
done

exit 0
