#!/bin/sh
# transforme les dates en nombre de seconde depuis minuit
# pour reecrire les start/stop des differentes phases du fichier sca

AWK=/bin/awk
SED=/bin/sed
GREP=/bin/grep
WC=/usr/bin/wc
RM=/bin/rm
CAT=/bin/cat
TOUCH=/bin/touch
DATE=/bin/date
ECHO=/bin/echo
LS=/bin/ls
MKDIR=/bin/mkdir
DefaultIFS=$' \t\n'
IFS=$DefaultIFS


scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"

#temporary files to synchronize scripts
tmppublicpath=${TMPPUBLICPATH}
$LS -l ${tmppublicpath} > /dev/null

#Path where the job will do temporary IO
. ${SCRIPTPATH}/set_iojobpath.sh
iojobpath=$(set_iojobpath)
cd ${iojobpath}

if [ ! $# = 1 ]; then
  $ECHO "FATAL (${scriptName}) usage: ./transdate.sh <scaXYZ.sum>"
  exit 0
fi

#inputs x-chexk sca file
inScaFile=$1
if [ ! -e $inScaFile ]; then
  $ECHO "FATAL (${scriptName}): $inScaFile not found"
  exit 1
fi

$AWK -v datesys=$DATE '
BEGIN {
  FS=",";
}

{
  cycle=$1;
  for (i=2; i<=NF; i++) {
    cmd=sprintf("%s +%%F -d \"%s\" ",datesys,$i);
    (cmd | getline day);
    close(cmd);
    cmd=sprintf("%s +%%s -d \"%s\" ",datesys,day);
    (cmd | getline s0);
    close(cmd);
    cmd=sprintf("%s +%%s -d \"%s\" ",datesys,$i);
    (cmd | getline s1);
    close(cmd);
    $i = s1 - s0;    
  }
  print $0;
}

' $inScaFile >> $inScaFile.trans

exit 0
