#!/bin/sh -xv
AWK=/bin/awk
SED=/bin/sed
GREP=/bin/grep
WC=/usr/bin/wc
RM=/bin/rm
CAT=/bin/cat
TOUCH=/bin/touch
DATE=/bin/date
ECHO=/bin/echo
LS=/bin/ls
MKDIR=/bin/mkdir
TR=/usr/bin/tr
FIND=/usr/bin/find
PRINTF=/usr/bin/printf
XARGS=/usr/bin/xargs
SORT=/bin/sort
QSUB=qsub

DefaultIFS=$' \t\n'
IFS=$DefaultIFS


scriptName="`basename $0`"
echo "Processing script ${scriptName} at `date`"

#Process cmd line args: the -src option is mandatory (source name as Abell85)
#action: gain|mspec (gain: gain-like doucble median filtering
#                   mspec: mean+sigma wo filetring)
action="-act gain"
sourceRadio=
dateSelected=
typeofproc=
#first and last cycle to process
#
firstCycle=
lastCycle=
#use -sim option to simulate processing (debug the script as if...)
simulationMode=""
while [ $# -gt 0 ]
do
  case "$1" in
      -act)  action="-act $2"; act=$2; shift;;
      -src)  sourceRadio="$2"; shift;;
      -date) dateSelected="-date $2"; dateJob="$2";     shift;;
      -type) typeofproc="-type $2"; type=$2; shift;;
      -fcycle) firstCycle="-fcycle $2"; fcycle="$2"; shift;;
      -lcycle) lastCycle="-lcycle $2"; lcycle="$2"; shift;;
       -sim) 
      simulationMode="-sim On"
      $ECHO "INFO ${scriptName} running in SIMUL mode";;
	-h)
	echo >&2 \
	    "usage: $0 -src source -date YYYYMMDD -type type [-fcycle firstCycle] [-lcycle lastCycle] [-sim to trig simulation mode]"
	exit 1;;
	*)  break;;	# terminate while loop
    esac
    shift
done

if [ "<${sourceRadio}>" = "<>" ]; then
    $ECHO "FATAL: You have forgotten to select the source option (-src)"
    exit 1
fi

if [ "<${dateSelected}>" = "<>" ]; then
    $ECHO "FATAL: You have forgotten to select the date option (-date)"
    exit 1
fi

if [ "<${typeofproc}>" = "<>" ]; then
    $ECHO "FATAL: You have forgotten to select the type option (-type)"
    exit 1
fi

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"
#temporary files to synchronize scripts
tmppublicpath=${TMPPUBLICPATH}
#Path of the utility scripts
scriptpath=${SCRIPTPATH}
#get the daq current irod status
#JEC 1/10/11 Use generic baodaqstatus name 
#### tag=`${DATE} +%F`
OUT1=${publicpath}/baodaqstatus-current.txt

if [ ! -e ${OUT1}  -o ! -r ${OUT1} ]; then
    $ECHO "FATAL (${scriptName}): ${OUT1} has a problem"
    exit 1
#JEC 29/9/11 avoid finished stuff
#    $RM -f ${tmppublicpath}/statusdaq.finished
#    ${scriptpath}/statusdaq.sh > ${OUT1}
#    while [ ! -f "${tmppublicpath}/statusdaq.finished" ]; do
#	sleep 30
#    done
#    $RM ${tmppublicpath}/statusdaq.finished
#protect against remove/rewriting    
#    $CHMOD -v 444 ${OUT1} 
fi

#assume 20 files/cycles cf. 30sec/cycle et 3sec par signal et fact 2 margin 
if [ "<${firstCycle}>" != "<>" -a "<${lastCycle}>" != "<>" ]; then
    jobBatchName="procspecmfib-${sourceRadio}${dateJob}${type}-${fcycle}-${lcycle}"
    nFiles=`expr ${lcycle} - ${fcycle} + 1`
    nFiles=`expr ${nFiles} \* 20`
else
    jobBatchName="procspecmfib-${sourceRadio}${dateJob}${type}-All"
    #assume 30 cycles maxi!
    nFiles=`expr 20 \* 30`

fi

jobLogName="${jobBatchName}.log.$$"

#Nbre de paquets utilises pour 1 spectre
tspwin="5120"
#calcul du scratch sachant que l'on nettoie apres chaque cycle
nSpectra=`expr 20 \* 25600 /  ${tspwin}`
scratchSize=`expr  20 \* 500 + ${nSpectra} \* 200 / 1000 + 5`

#le cpu total tient compte de l'emsemble des ficheirs a traiter
#cpu=`expr ${nFiles} \* 60 \* 50`  # BQS estimation
cpu=`expr ${nFiles} \* 60`

qsub -P P_baoradio -l sps=1,irods=1,ct=${cpu},vmem=1000M,fsize=${scratchSize}M -o $jobLogName -j yes -N $jobBatchName -m be -M ${LOGNAME}@lal.in2p3.fr -V <<EOF

${SCRIPTPATH}/proc_specmfib.sh ${action} -src ${sourceRadio} ${dateSelected} ${typeofproc} ${firstCycle} ${lastCycle} ${simulationMode}
EOF
