#include "machdefs.h"

//---- System et stdc++ include files
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <iostream>
#include <fstream>
#include <complex>

#include <typeinfo>
#include <string>
#include <vector>
#include <map>
#include <functional>
#include <list>

//---- Sophya include files
#include "sopnamsp.h"
#include "basetools.h"
#include "systools.h"
#include "sutils.h"
#include "ntools.h"
#include "array.h"
#include "histats.h"

//---- Spiapp include files
#include "nobjmgr.h"
#include "servnobjm.h"

//---- Include files from additionnal modules

//---- function to compare bits on double 
int_8 BitCmp64(double v,int_8 flg) 
{return ((int_8)((v<0.) ? v-0.1 : v+0.1))&flg;} 

//---- function for Adding and displaying Objects  
void Keep_Object(AnyDataObj & obj, string const & nom) 
{ 
  string name = nom; 
  NamedObjMgr om; 
  if (om.GetObj(name)) 
    cerr << "KeepObj()/Warning Already kept object " << endl; 
  else om.AddObj(obj, name); 
} 

void Display_Object(AnyDataObj & obj, string const & opt, string const & nom) 
 { 
  string name = nom; 
  NamedObjMgr om; 
  if (!om.GetObj(name)) 
    om.AddObj(obj, name); 
  om.DisplayObj(name, opt); 
} 

//---- function for getting and setting ObjectManager variables  
void Set_ObjMgrVar(MuTyV v, string const & nom) 
{ 
  NamedObjMgr om; 
  om.SetVar(nom, (string)v); 
} 

MuTyV Get_ObjMgrVar(const char * nom) 
{ 
  string name = nom; NamedObjMgr om; 
  MuTyV v = om.GetVar(name); 
  return v; 
} 

//---- Macro for Objects and variables saving
#define KeepObj(obj) Keep_Object(obj, #obj)
#define GetOMVar(var) Get_ObjMgrVar( #var )
#define SetOMVar(var) Set_ObjMgrVar(var, #var )

//---- Macro Displaying objects and command execution
#define DispObj(obj, att) Display_Object(obj, att, #obj); 

#define ExecCmd(cmd) srvo.ExecuteCommand(cmd); 



//-------------------------------------------------//
//----------------- User Functions ----------------//
//-------------------------------------------------//

extern "C" {
  int dorebin( vector<string>& args );
}

int dorebin( vector<string>& args )
{
// Some definitions to help using spiapp;
NamedObjMgr omg;
Services2NObjMgr& srvo = *omg.GetServiceObj();

//-------------- Object List --------------
//Number of objects = 2
string ___nomobj;

___nomobj = "invec";
TVector< r_8 > * ___invec = dynamic_cast< TVector< r_8 >  * >(omg.GetObj(___nomobj));
if(___invec==NULL) throw NullPtrError("CxxExecutor::PutObject: Non existing object invec... please update file");
TVector< r_8 > & invec = (*___invec);




//--------------------------------------------//
//----------------- User Code ----------------//
//--------------------------------------------//

 sa_size_t length=invec.NElts();
 sa_size_t packFactor=atoi(args[0].c_str());
 sa_size_t redlength=length/packFactor;

 TVector<r_8> outvec(redlength);
 for (sa_size_t ibin=0; ibin<redlength; ibin++){
   sa_size_t binLow= ibin*packFactor;
   sa_size_t binHigh= binLow + packFactor -1;
     TVector<r_8> tmp;
     tmp = invec.SubVector(Range(binLow,binHigh));
     double mean; 
     double sigma;
     MeanSigma(tmp,mean,sigma);
     outvec(ibin)=mean;
 }
 KeepObj(outvec);

return 0;
}
