#!/bin/sh
#liste des "sources" enregistrees sous Amas
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
MKDIR=/bin/mkdir
CAT=/bin/cat
PRINTF=/usr/bin/printf
RM=/bin/rm
SORT=/bin/sort
XARGS=/usr/bin/xargs
WC=/usr/bin/wc
DefaultIFS=$' \t\n'
IFS=$DefaultIFS

# Irods environment settings
. /usr/local/shared/bin/irods_env.sh -noverbose

scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"

#Path where the job will do temporary IO
. ${SCRIPTPATH}/set_iojobpath.sh
iojobpath=$(set_iojobpath)
cd ${iojobpath}


OUT1=./baoils.$$
ils /baoradio/data/AmasNancay/ > ${OUT1}
OUT2=./baoawk1.$$
$AWK '($1=="C-") {print $2}' ${OUT1} > ${OUT2}
$RM $OUT1
#Sequence 
tableau=( `$CAT $OUT2 | $AWK '{print $1}'` )
IFS='
'
tableau=( $( $PRINTF "%s\n" "${tableau[@]}" | $AWK 'x[$0]++ == 0' ) )
IFS=$DefaultIFS

$RM $OUT2

for i in ${tableau[@]}
do
  $ECHO "source $i"
  listedate=( `ils $i | $AWK '($1=="C-"){print $2}'`)
  IFS='
'
  listedate=( $( $PRINTF "%s\n" "${listedate[@]}" | $AWK 'x[$0]++ == 0' ) )
  IFS=$DefaultIFS

  for j in ${listedate[@]}
  do
    gainOk=`ils ${j} | $GREP -i "gain_" | $WC -l`
    if [ ${gainOk} -gt 0 ]; then
	$ECHO ">>> $j ---> GAIN Done (${gainOk})"
    else
	$ECHO ">>> $j ---> GAIN To be computed"
    fi
  done 
done
