#!/bin/sh -xv

#Process cmd line args: the -src option is mandatory (source name as Abell85)
sourceRadio=
#use -sim option to simulate processing (debug the script as if...)
simulationMode=""
while [ $# -gt 0 ]
do
  case "$1" in
      -src)  sourceRadio=$2; shift;;
      -sim) simulationMode="-sim";;
	-h)
	    echo >&2 \
	    "usage: $0 -src souce [-sim]"
	    exit 1;;
	*)  break;;	# terminate while loop
    esac
    shift
done

jobBatchName="gains-$sourceRadio"
jobLogName="${jobBatchName}.log.$$"

qsub -l u_sps_baoradio,u_irods,u_irods_baoradio,T=120000,M=1000MB,scratch=500MB,platform=LINUX -eo -o $jobLogName -N $jobBatchName -mb -me -mu ${LOGNAME}@lal.in2p3.fr <<EOF
/afs/in2p3.fr/home/c/campagne/private/work/AmasNancay/gainmaker.sh  -src ${sourceRadio} ${simulationMode}
EOF
