#!/bin/sh -xv

scriptName="`basename $0`"
echo "Processing script ${scriptName} at `date`"

#Process cmd line args: the -src option is mandatory (source name as Abell85)
sourceRadio=
dateSelected=
dateJob=
freqBAOCalib=
#use -sim option to simulate processing (debug the script as if...)
simulationMode=""
while [ $# -gt 0 ]
do
  case "$1" in
      -src)  sourceRadio="$2"; shift;;
      -date) dateSelected="-date $2"; dateJob="$2";     shift;;
      -freq) freqBAOCalib="-freq $2"; shift;;
      -sim) 
      simulationMode="-sim On"
      $ECHO "INFO ${scriptName} running in SIMUL mode";;
	-h)
	echo >&2 \
	    "usage: $0 -src souce -date YYYYMMDD [-freq freq in MHz (default ${freqBAOCalib})] [-sim to trig simulation mode]"
	exit 1;;
	*)  break;;	# terminate while loop
    esac
    shift
done


if [ "<${sourceRadio}>" = "<>" ]; then
    $ECHO "FATAL: You have forgotten to select the source option (-src)"
    exit 1
fi


jobBatchName="onoff-${sourceRadio}${dateJob}"

jobLogName="${jobBatchName}.log.$$"

qsub -l u_sps_baoradio,u_irods,u_irods_baoradio,T=120000,M=1000MB,scratch=1000MB,platform=LINUX -eo -o $jobLogName -N $jobBatchName -mb -me -mu ${LOGNAME}@lal.in2p3.fr <<EOF
/afs/in2p3.fr/home/c/campagne/private/work/AmasNancay/onoffmaker.sh  -src ${sourceRadio} ${dateSelected} ${freqBAOCalib} ${simulationMode}
EOF
