#!/bin/sh -xvf
DATE=/bin/date
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
WC=/usr/bin/wc
CAT=/bin/cat
PRINTF=/usr/bin/printf
FIND=/usr/bin/find
MKDIR=/bin/mkdir
XARGS=/usr/bin/xargs
SORT=/bin/sort
RM=/bin/rm
TR=/usr/bin/tr
CP=/bin/cp
LS=/bin/ls
CHMOD=/bin/chmod

#Process cmd line args: the -src option is mandatory (source name as Abell85)
sourceRadio=
force=
while [ $# -gt 0 ]
do
  case "$1" in
      -src)  sourceRadio=$2; shift;;
      -force) force="Yes";;
	-h)
	    echo >&2 \
	    "usage: $0 -src souce"
	    exit 1;;
	*)  break;;	# terminate while loop
    esac
    shift
done

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"


#temporary files to synchronize scripts
tmppublicpath=${TMPPUBLICPATH}
$LS -l ${tmppublicpath} > /dev/null

#Path of the utility scripts
scriptpath=${SCRIPTPATH}

#JEC 1/10/11 Use generic baodaqstatus name 
#the daq current irod status
#tag=`${DATE} +%F`
#OUT1=${publicpath}/baodaqstatus-${tag}.txt
OUT1=${publicpath}/baodaqstatus-current.txt

if [ ! -e ${OUT1}  -o ! -r ${OUT1} ]; then
    $ECHO "FATAL (${scriptName}): ${OUT1} has a problem"
    exit 1
fi

jobBatchName="scaMaker-$sourceRadio"
jobLogName="${jobBatchName}.log.$$"

qsub -l u_sps_baoradio,u_irods,u_irods_baoradio,T=100000,M=256MB,scratch=700MB,platform=LINUX -eo -o $jobLogName -N $jobBatchName -mb -me -mu ${LOGNAME}@lal.in2p3.fr <<EOF
/afs/in2p3.fr/home/c/campagne/private/work/AmasNancay/scaextractor.sh  ${sourceRadio} ${force}
EOF
