#!/bin/sh

#Process cmd line args: the -src option is mandatory (source name as Abell85)
sourceRadio=
while [ $# -gt 0 ]
do
  case "$1" in
      -src)  sourceRadio=$2; shift;;
	-h)
	    echo >&2 \
	    "usage: $0 -src souce"
	    exit 1;;
	*)  break;;	# terminate while loop
    esac
    shift
done

jobBatchName="headerMaker-$sourceRadio"
jobLogName="${jobBatchName}.log.$$"

qsub -P P_baoradio -l sps=1,irods=1,ct=2000,vmem=256M,fsize=700M -o $jobLogName -j yes -N $jobBatchName -m be -M ${LOGNAME}@lal.in2p3.fr -V <<EOF

${SCRIPTPATH}/hdrfitsextractor.sh  $sourceRadio
EOF
