/*
 Pilote Indi BAORadio
 franckrichard033@gmail.com
 Décembre 2011
*/

#ifndef BAO_H
#define BAO_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>
#include <unistd.h>
#include <time.h>
#include <memory>
#include <pthread.h>
#include <iostream>
#include <time.h>
#include <unistd.h>
#include <sys/time.h>
#include <fstream>

#include <config.h>

#include "indicom.h"

#include "Socket.h"
#include "indidevapi.h"
#include "indicom.h"
#include "ServerSocket.h"
#include "SocketException.h"
#include "astro.h"
#include "filetools.h"

#define MAXCARACTERES 1024

#define MAXATTENTE 80                // Si une commande ne recoit pas d'acknowledge. Alors refaire 80 tentatives en renvoyant la commande
#define MAXANOMALIES 2               // Si pas de réponse au bout de 80 tentatives -> erreur critique -> socket perdu ?
#define MAXANOMALIESGOTO 1500

#define NBREPASCODEURSAZ  4000
   

using namespace std;

struct Position
{
    long int x;
    long int y;
};

struct DefSocket
{
    ServerSocket new_sock;           // socket permettant de gérer la connexion avec une antennes

    string IP;                       // IP de l'antenne

    bool Connected;                  // le micro-contrôleur est-il connecté ?
    bool PosValides;                 // le micro-contrôleur a-t-il donné une position des moteurs valide ?
    char status;                     // status='B' pour busy  'R' pour READY
    int sendalertes;                 // une requête 'send' a généré une erreur sur le réseau
    int AttenteExecution;	     // L'antenne parvient-elle à executer un cycle de commandes ?
    int AnomaliesExecution;	     // Erreur critique. L'antenne ne répond plus !

    Position Pos;                    // dernière position retournée par le microcontrôleur
    Position Delta;                  // Corrections en Az et Ha
    int etape;                       // étape dans le cycle de commandes/réponses entre PC et microcontroleurs

    bool ack_status;                 // Etat des acknowledges ?
    bool ack_pos;                    // le PC a reçu une confirmation du microcont après un ordre POSITION
    bool ack_park;	             // le PC a reçu une confirmation du microcont après un ordre PARK
    bool ack_abort;                  // le PC a reçu une confirmation du microcont après un ordre ABORT
    bool ack_goto;                   // le PC a reçu une confirmation du microcont après un ordre GOTO
    bool GotoOk;                     // Est-ce que le dernier goto est OK ?
    
    
};


ServerSocket server( 8000 );         // Le PC et les antennes communiquent par le biais du port 8000 sur le réseau tcp

class BAO : public Astro
{
public:
    BAO();
    ~BAO();

    void ISGetProperties (const char *dev);
    void ISNewNumber (const char *dev, const char *name, double values[], char *names[], int n);
    void ISNewText (const char *dev, const char *name, char *texts[], char *names[], int n);
    void ISNewSwitch (const char *dev, const char *name, ISState *states, char *names[], int n);
    void ISPoll ();

    void *pThreadSocket ();
    void *pThreadExit ();

    bool COMMANDE(int numsocket, char* Commande, char* Params);
    bool ExtractPosition(string str, Position *result);

    void connection_lost();
    void connection_resumed();

    bool STATUS(int numsocket);
    bool POSITION(int numsocket);
    bool ABORT(int numsocket);
    bool PARK(int numsocket);
    bool GOTO(int numsocket, int deltaAz, int deltaAlt);
    void ADDEC2Motor(double newRA, double newDEC);
    int  AntennesConnectees();
    void DeconnecterSocket(int num);
    void InitAntennes();
    bool ChargementParametresAlignement(string fileName);
    bool is_readable( const std::string & file );
  
    /*******************************************************/
    /* Connection Routines
    ********************************************************/
    void init_properties();
    void get_initial_data();
    void connect_telescope();
    bool is_connected(void);

    /*******************************************************/
    /* Misc routines
    ********************************************************/
    bool process_coords();
    int get_switch_index(ISwitchVectorProperty *sp);

    /*******************************************************/
    /* Simulation Routines
    ********************************************************/
    void enable_simulation(bool enable);

    /*******************************************************/
    /* Error handling routines
    ********************************************************/
    void slew_error(int slewCode);
    void reset_all_properties();
    void handle_error(INumberVectorProperty *nvp, int err, const char *msg);
    void correct_fault();



private:

    enum BAO_STATUS { BAO_TRANSIT, BAO_TRACKING, BAO_PARK };

    /* Switches */
    ISwitch ConnectS[2];
    ISwitch OnCoordSetS[2];
    ISwitch AbortSlewS[1];
    ISwitch ParkS[1];

    /* Texts */
    IText PortT[1];
    IText ObjectT[1];

    /* Numbers */
    //INumber EquatorialCoordsRN[2];
    INumber EquatorialCoordsWN[2];
    INumber GeographicCoordsWN[2];
    INumber ActualisationN1[1];
    INumber ActualisationN2[1];

    //INumber SlewAccuracyN[2];
    //INumber TrackAccuracyN[2];

    /* Switch Vectors */
    ISwitchVectorProperty ConnectSP;
    ISwitchVectorProperty OnCoordSetSP;
    ISwitchVectorProperty AbortSlewSP;
    ISwitchVectorProperty ParkSP;

    /* Number Vectors */
    //INumberVectorProperty EquatorialCoordsRNP;
    INumberVectorProperty EquatorialCoordsWNP;
    INumberVectorProperty GeographicCoordsWNP;
    //INumberVectorProperty SlewAccuracyNP;
    //INumberVectorProperty TrackAccuracyNP;
    INumberVectorProperty ActualisationNP1;
    INumberVectorProperty ActualisationNP2;


    /* Text Vectors */
    ITextVectorProperty PortTP;
    ITextVectorProperty ObjectTP;



protected:
    int SocketsNumber;                   // nbre de sockets utilisés pour connecter les antennes
    bool InitThreadOK;                   // Le thread est bien actif
    DefSocket Sockets[MAXHOSTNAME + 1];  // Etat de chaque socket. Un socket permet la communication avec une antenne
    pthread_t th1;                       // le pointeur du thread

    double JD;				 // Jour julien
    double lastRA;                       // Sauvegarde de la dernière position avant actualisation
    double lastDEC;
    double JJAnc;                        // Sauvegarde du jour julien lors de la dernière actualisation de la position (fct Goto)
    double ActualisationTM1;             // Délais entre deux actualisations dans les modes transit et tracking
    double ActualisationTM2;
    double Longitude;			 // Longitude et latitude du lieu d'observation
    double Latitude;
    bool   ActualisationPosition;        // Permet de faire les étapes nécessaires pour réaliser un mouvement
    bool   Abort;			 // Annulation du mouvement en cours
    bool   Park;			 // On place les antennes dans une position de repos
    bool   Suivi;			 // Suivi d'un objet en cours...
    bool   UpdateGoto;			 // On peut exécuter un Goto
    bool   Exit;                         // On ferme le driver

    int    currentSet;                   // Variable interne de l'interface indi
    int    lastSet;                      // Variable interne de l'interface indi
    int    TrackingMode;                 //1 : Transit           2: Tracking

    Position TargetPosition;             //Position à atteindre en coordonnées équatoriales
};

#endif
