// Implementation of the ClientSocket class

#include "ClientSocket.h"
#include "SocketException.h"


#include <iostream>
#include <string>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>


ClientSocket::ClientSocket ( std::string host, int port )
{
  if ( ! socketdef::create() )
    {
      throw SocketException ( "Could not create client socket." );
    }

  if ( ! socketdef::connect ( host, port ) )
    {
      throw SocketException ( "Could not bind to port." );
    }
}


const ClientSocket& ClientSocket::operator << ( const std::string& s ) const
{
  if ( ! socketdef::send ( s ) )
    {
     // throw SocketException ( "Could not write to socket." );
    }

  return *this;

}


const ClientSocket& ClientSocket::operator >> ( std::string& s ) const
{
  if ( ! socketdef::recv ( s ) )
    {
    //   throw SocketException ( "Could not read from socket." );
    }

  return *this;
}


void ClientSocket::recv( std::string& s ) 
{
  if ( ! socketdef::recv ( s ) )
    {
      sleep(1);

      if (! socketdef::shutdown() ) std::cout << "shutdown impossible.\n";

      if (! socketdef::create() ) std::cout << "create impossible.\n";

      if (! socketdef::connect((std::string)"192.168.0.1", 8000)) { std::cout << "connect impossible.\n"; socketdef::shutdown(); } else {   std::cout << "Reconnexion reussie.\n"; }
    }
}

