/*
The stellarium telescope library helps building
telescope server programs, that can communicate with stellarium
by means of the stellarium TCP telescope protocol.
It also contains smaple server classes (dummy, Meade LX200).

Author and Copyright of this file and of the stellarium telescope library:
Johannes Gajdosik, 2006

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _SERVER_BAO_HPP_
#define _SERVER_BAO_HPP_

#include "Server.hpp"
#include <iostream>
#include <string.h>
#include <sstream>
#include "ClientSocket.h"
#include "SocketException.h"
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <X11/Xlib.h>
#include "filetools.h"
#include "astro.h"
#include "math.h"
#include <time.h>
#include <unistd.h>
#include <sys/time.h>


// couleurs utilisées dans le terminal

#define red1 "\033[0;31m"
#define blue1 "\033[0;34m"
#define green1 "\033[0;32m"
#define black1 "\033[0;30m"
#define grey1 "\033[1;30m"
#define red2 "\033[1;31m"
#define blue2 "\033[1;34m"
#define green2 "\033[1;32m"
#define black2 "\033[1;30m"
#define grey2 "\033[1;37m"


// limites des tableaux

#define MAXLOG 1000
#define MAXOBJETS 100
#define MAXANTENNES 50


//dimensions de la fenêtre graphique

#define haut_fenetre 10+22*10
#define larg_fenetre 605

using namespace std;


struct DefAntenne
{
    unsigned char ip;			// Adresse ip d'une antenne

    char ok;				// actuellement disponible ?
};

// objets stockés dans le fichier de mouvements

struct DefObjets
{
    double JJ;				// Jour julien où le télescope doit aller pointer vers l'objet
    double Duree;			// Durée de l'observation de l'objet en sec
    string ad;				// Ascension droite J2000 de l'objet
    string de;				// déclinaison J2000 de l'objet
    bool exec;				// En cours d'exécution ?
};


//! Telescope server class for a virtual telescope that requires no physical device.
//! Useful for remote connection testing.
class ServerDummy : public Server, public Astro
{
public:
	ServerDummy(int port);
	void step(long long int timeout_micros);

        void Affiche(string Message, bool AfficheEcran);
        void Affiche(stringstream *Message, bool AfficheEcran);
        void Erreur(string chaine);
        void Erreur(stringstream *Message);
        void initialiserFenetre();
        void Dessiner();
        void rouler();
        void LireReponse();
        bool VerifReponse(string reponseattendue);
        void Update();
        bool EnvoyerCoordGeographiques();
        bool Park();
        bool Abort();
        bool Goto(string ar, string dec, bool Transit, bool J2000);
        bool Connect(bool connect);
        bool Decomposition(string chaine, char type, float *a1, float *a2, float *a3);
        int  readline (FILE * pfile, char *tab);
        bool ChargementParametres(string fileName);
	
private:
	void gotoReceived(unsigned int ra_int,int dec_int);
	double current_pos[3];
	double desired_pos[3];
	double last_pos[3];
	long long int next_pos_time;

        // Variables globales

           XFontStruct * fd;                           // Police de caractères dans la fenêtre graphique

           char ChoixCouleurs;                         // 1-pour un terminal à fond blanc    2-pour un terminal à fond noir

           string logs[MAXLOG];                        // Sauvegarde de toutes les actions et réponses dans un tableau logs

           int delaitransit;				// Délai entre deux actualisations de la position en mode transit
           int delaitracking;				// Délai entre deux actualisations de la position en mode tracking
           int lognum;					// Nbre d'enregistrements dans le tableau logs
           int numAntenne;				// Nbre d'antennes connectées
           int numobjets;				// Nbre d'objets dans le dernier fichier de mouvements chargé
           int runnum;					// Numéro de l'objet actuellement visé dans le fichier de mouvement

           double Pression;				// Pression atmosphérique en mBar
           double Temperature; 			// température de l'atmosphère

           bool NoExit;				// A-t-on tapé exit pour sortir ? Permet de fermer le thread à ce moment-là
           bool Transit;				// Si oui, le mode transit est activé, sinon, c'est le mode tracking
           bool run;					// execute actuellement un fichier de mouvements
           bool exitrun;				// doit-on sortir du programme à la fin de l'execution de la commande run ?
           bool J2000;					// est-ce que les coordonnées du fichier de mouvements sont en coordonnées J2000 ?

           struct DefAntenne *Antennes;		// Sauvegarde de la situation actuelle de l'antenne i
           struct DefObjets  *objets;			// Liste des objets chargés depuis un fichier de mouvements

           string LatitudeChar;			// Latitude du lieu d'observation. Chargée depuis le fichier de configuration
           string LongitudeChar;			// Longitude du lieu d'observation. Chargée depuis le fichier de configuration
           string Serveur;				// Nom ou IP du serveur faisant tourner indi_BAO. Par defaut c'est localhost
           string Port; 				// Port utilisé pour connecter le serveur indi_BAO

           ClientSocket *client_socket;		// Socket permettant la connexion avec le pilote indi_BAO

           Display * d;				// contexte graphique
           Window w;					// fenêtre graphique
           Pixmap db;					// copie de la fenêtre pour permettre une actualisation sans scintillement
           GC noir, vert, rouge, gris;			// couleurs utilisées dans la fenêtre graphique
};

#endif
