// Definition of the Socket class

#ifndef socket_class
#define socket_class


#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <string>
#include <arpa/inet.h>
#include <iostream>
#include "stdio.h"


const int MAXHOSTNAME = 1000;
const int MAXCONNECTIONS = 5;
const int MAXRECV = 5000;



class socketdef
{
 public:
  socketdef();
  virtual ~socketdef();


  // Server initialization
  bool create();
  bool bind ( const int port );
  bool listen() const;
  bool accept ( socketdef& ) const;

  // Client initialization
  bool connect ( const std::string host, const int port );

  // Data Transimission
  bool send ( const std::string ) const;
  int recv ( std::string& ) const;


  void set_non_blocking ( const bool );

  bool is_valid() const { return m_sock != -1; }

  bool shutdown();

 private:

  int m_sock;
  sockaddr_in m_addr;




};


#endif
