////////////////////////////////
// Classe Astro               //
// Franck RICHARD             //
// BAORadio                   //
// franckrichard033@gmail.com //
// juin 2011                  //
////////////////////////////////

#ifndef Astro_class
#define Astro_class

#include "math.h"
#include "stdio.h"
#include <iostream>
#include <string.h>
#include <sstream>
#include <iomanip>

using namespace std;

//////////////////////////////
// Constantes Mathématiques //
//////////////////////////////

#define Pi		3.14159265358979323846264338327
#define Pidiv180	0.01745329251994329576923690768
#define N180divPi	57.2957795130823208767981548141
#define Pi2          	6.28318530717958647692528676655
#define Pidiv2		1.57079632679489661923132169163

#define gmax(A,B) ((A)>(B)?(A):(B))

#define gmin(A,B) ((A)<(B)?(A):(B))


struct Coordonnees
{
    string ar;				// Coordonnées horaires d'un objet
    string dec;
};

class Astro 
{
public:
    Astro();
    ~Astro();

    void   DefinirDateHeure(double Annee, double Mois, double Jour, double Heu, double Min, double Sec);
    void   DefinirPressionTemp(double P, double T);
    void   DefinirLongitudeLatitude(double log, double lat);
    double VerifAngle(double Angle);
    double Arrondi(double a);
    string DHMS(double mema, bool HMS);
    void   Azimut(double Ar, double De, double *azi, double *hau);
    void   Precession(double *ar, double *de);
    void   NutationEtoile(double *ar, double *de);
    void   AberrationAnnuelle(double *ar, double *de);
    void   CalculJJ(double Heure);
    double CalculJJ(double A, double M, double J, double Heure);
    void   CalculTSL();  
    double RefractionAtmospherique(double ht);
    double CalculLongitudeSoleil();
    double TSL(double JJ,double HeureSiderale,double Longitude);
    void   Nutation();
    void   Obliquite(double JJ);
    void   atms ( double rt, double tt, double dnt, double gamal, double r,
                   double *dn, double *rdndr );
    void   atmt ( double robs, double tdkok, double alpha, double gamm2,
                   double delm2, double c1, double c2, double c3,
                   double c4, double c5, double c6, double r,
                   double *t, double *dn, double *rdndr );
    void   slaRefro ( double zobs, double hm, double tdk, double pmb,
                double rh, double wl, double phi, double tlr,
                double eps, double *ref );
    float  slaRange(float angle );
    double slaDrange(double angle );
    void   CalculARDecSoleil(Coordonnees *Soleil);
    
    
    double GetAnnee() { return Annee; }
    double GetMois()  { return Mois;  }
    double GetJour()  { return Jour;  }
    double GetHeure() { return Heure; }
    double GetMin()   { return Min;   }
    double GetSec()   { return Sec;   }
    double GetJJ()    { return JJ;    }  

  
    
    
private:
    double Longitude;
    double Latitude;
    double JJ;
    double CorP;
    double CorEP;
    double Annee;
    double Mois;
    double Jour;
    double Heure;
    double Min;
    double Sec;
    double ep;
    double hs;
    double UTCP;
    double tsl;
    double LongitudeSoleil;
    double Pression;
    double Temp;
};


#endif
